/**
 * Converted JavaScript, originally located in linkblock.vm
 */
GH.DetailsIssueLinks = {};

GH.DetailsIssueLinks.updateRemoteLink = function (issueLink) {
    var htmlElementId = issueLink.htmlElementId;
    JIRA.SmartAjax.makeRequest({
        error: function(jqXHR, textStatus, errorThrown) {
            AJS.$("#" + htmlElementId + " div.link-content .link-loading").
                removeClass("link-loading").
                addClass("link-loading-failed").
                html(AJS.I18n.getText("common.concepts.loading.failed"));
            var defaultLinkIcon = issueLink.defaultLinkIcon;
            AJS.$("#" + htmlElementId + " div.link-content .link-throbber").html("<img src='"+defaultLinkIcon+"' width='16' height='16' title='' alt='' />");
        },
        success: function(data) {
            AJS.$("#" + htmlElementId + " div.link-content").html(data);
        },
        url: GH.Ajax.CONTEXT_PATH + "/rest/viewIssue/1/remoteIssueLink/render/" + issueLink.id
    });
};

/**
 * Load remote links (replacing initially rendered stubs)
 */
GH.DetailsIssueLinks.loadRemoteLinks = function(issueLinks) {
    _.each(issueLinks.issueLinkTypeEntries, function(issueLinkType) {
        _.each(issueLinkType.issueLinkEntries, function(issueLink) {
            if (issueLink.requiresAsyncLoading) {
                GH.DetailsIssueLinks.updateRemoteLink(issueLink);
            }
        });
    });
};
