// Remove this file when the inline-editable feature comes to the bright side
/**
 * This is responsible for returning a corresponding instance of objects needed for Details View based on the dark feature status.
 *
 * It is used mainly in {@code DetailsView.js}, {@code DetailsFieldEditModel.js}, {@code DetailsFieldRenderer.js}
 */
(function (_) {
    var detailsViewTemplateMerged = false;

    AJS.namespace("GH.DetailsObjectFactory", null, {
        getDetailsFieldRenderer: function getDetailsFieldRenderer() {
            if (this.isInlineEditableEnabled()) {
                return require('jira-agile/rapid/ui/detail/inlineedit/inline-editable-details-field-renderer');
            } else {
                return require('jira-agile/rapid/ui/detail/legacy/legacy-details-field-renderer');
            }
        },

        getDetailsModel: function getDetailsModel() {
            if (this.isInlineEditableEnabled()) {
                return require('jira-agile/rapid/ui/detail/inlineedit/inline-editable-details-model');
            } else {
                return require('jira-agile/rapid/ui/detail/legacy/legacy-details-model');
            }
        },

        mergeDetailsViewTemplate: function mergeDetailsViewTemplate() {
            if (detailsViewTemplateMerged) {
                return;
            }
            if (this.isInlineEditableEnabled()) {
                _.extend(GH.tpl.detailview, GH.tpl.inlineEditableDetailview);
            } else {
                _.extend(GH.tpl.detailview, GH.tpl.legacyDetailview);
            }
            detailsViewTemplateMerged = true;
        },

        isInlineEditableEnabled: function isInlineEditableEnabled() {
            return GH.Features.EDITABLE_DETAIL_VIEW_ENABLED.isEnabled();
        }
    });
})(require("underscore"));