define('jira-agile/rapid/ui/detail/inlineedit/details-view-reloader',[
    'require'
], function(
    require
) {
    'use strict';

    var jQuery = require('jquery');
    var _ = require('underscore');
    var EditableDetailsViewReloadReason = require('jira-agile/rapid/ui/detail/inlineedit/details-view-reload-reason');
    /* global GH */
    var DetailsView = GH.DetailsView;
    var DetailsModel = GH.DetailsObjectFactory.getDetailsModel();


    var ISSUE_EDITOR_RELATED_TABS = ['details', 'header', 'description'];

    var TABS_RELOADED_BY_REASON = {};
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.HEADER_FIELD_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.DETAILS_FIELD_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.LINKED_ISSUES_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.LINKED_ISSUE_CREATED_AND_COMMENTED] = _.union(ISSUE_EDITOR_RELATED_TABS, ['comment']);
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.DESCRIPTION_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.ATTACHMENTS_CHANGED] = ['attachment'];
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.COMMENTS_CHANGED] = ['comment'];
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.SUBTASKS_CHANGED] = _.union(['sub_tasks'], ISSUE_EDITOR_RELATED_TABS);
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.VERSION_PANEL_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.EPIC_PANEL_CHANGED] = ISSUE_EDITOR_RELATED_TABS;
    TABS_RELOADED_BY_REASON[EditableDetailsViewReloadReason.ISSUE_ASSIGNED_AND_COMMENTED] = _.union(ISSUE_EDITOR_RELATED_TABS, ['comment']);

    var EditableDetailsViewReloader = {
        reload: function(reloadReason, savedFieldId, refreshSingleFieldCallback) {
            if (TABS_RELOADED_BY_REASON[reloadReason]) {
                var tabsNeededReload = TABS_RELOADED_BY_REASON[reloadReason];
                var DetailsFieldRenderer = require('jira-agile/rapid/ui/detail/inlineedit/inline-editable-details-field-renderer');
                _.each(tabsNeededReload, function(tabId) {
                    loadTabContent(tabId).done(reloadDetailViewTab(DetailsFieldRenderer, tabId, savedFieldId, refreshSingleFieldCallback));
                });
            }
        }
    };

    function reloadDetailViewTab(detailsFieldRenderer, tabId, savedFieldId, refreshSingleFieldCallback) {
        return function(data) {
            if (!_.isUndefined(DetailsModel.viewData) && !_.isNull(DetailsModel.viewData)) {
                // update model with newly updated tab
                DetailsModel.viewData.tabs.defaultTabs = _.map(DetailsModel.viewData.tabs.defaultTabs, function(oldTab) {
                    var newTab = _.findWhere(data.defaultTabs, {tabId: oldTab.tabId});
                    return newTab ? newTab : oldTab;
                });
                if (!_.isUndefined(savedFieldId) && !_.isUndefined(refreshSingleFieldCallback) && _.isFunction(refreshSingleFieldCallback)) {
                    refreshSingleFieldCallback(savedFieldId);
                } else {
                    var $detailContainer = jQuery('#ghx-detail-issue');
                    if (tabId === 'header') {
                        detailsFieldRenderer.renderDetailsHeaderFields(DetailsModel.viewData, $detailContainer, DetailsView.opts);
                    } else {
                        var updatedViewData = {
                            tabs: {
                                defaultTabs: data.defaultTabs
                            }
                        };

                        var tabs = detailsFieldRenderer.buildTabs(updatedViewData);
                        var $detailsViewContent = $detailContainer.find('#ghx-detail-nav');
                        detailsFieldRenderer.renderTabsContent(tabs, $detailContainer.find('.ghx-detail-nav-menu'), $detailsViewContent);
                        DetailsView.registerListenersForTab(tabId, $detailsViewContent);
                    }
                    /* global GH */
                    GH.DetailsViewScrollTracker.afterDetailsViewLoaded({
                        issueId: DetailsModel.viewData.id
                    });
                }
            }
        }
    }

    function loadTabContent(tabId) {
        var deferred = new AJS.$.Deferred();
        var data = {
            rapidViewId: DetailsView.rapidViewId,
            issueIdOrKey: DetailsView.selectedIssueKey,
            loadSubtasks: DetailsView.opts.showSubtaskTab
        };
        if (tabId === 'attachment' && !_.isUndefined(DetailsView.getAttachmentViewQuery)) {
            data = _.extend(data, DetailsView.getAttachmentViewQuery());
        }
        GH.Ajax.get({
            url: '/xboard/issue/details/' + tabId,
            data: data
        }, 'detailView/' + tabId).done(function(data) {
            deferred.resolveWith(null, [data]);
        });

        return deferred.promise();
    }

    return EditableDetailsViewReloader;
});