define('jira-agile/rapid/ui/detail/inlineedit/issue-editor-fake-server', function () {

    var numberOfServerCallsToLoadIssue = 0;
    var numberOfServerCallsToSaveIssue = 0;

    var FakeServer = {
        responses: {
            "200_json": function _json(request) {
                this._makeIssueResponse(request, 200);
            },
            "200_html": function _html(request) {
                this._makeHtmlErrorResponse(request, 200, "<!doctype html><html><body><div>Probably not logged in</div></body></html>");
            },
            "500": function _(request) {
                this._makeHtmlErrorResponse(request, 500, "<!doctype html><html><body><div>500 Internal server error</div></body></html>");
            }
        },
        setup: function setup() {
            this.nextResponse = this.responses["200_json"];
            this.issueId = 1;
            this.issueKey = 'ISS-1';
            numberOfServerCallsToLoadIssue = 0;
            numberOfServerCallsToSaveIssue = 0;

            this.sandbox = sinon.sandbox.create({ useFakeServer: true });
            this.server = this.sandbox.server;

            this.server.respondWith(new RegExp(AJS.contextPath() + "/secure/AjaxIssueAction!default\\.jspa.*"), function (request) {
                numberOfServerCallsToLoadIssue++;
                this.nextResponse(request);
            }.bind(this));

            this.server.respondWith("POST", new RegExp(AJS.contextPath() + "/secure/DetailsViewAjaxIssueAction\\.jspa.*"), function (request) {
                numberOfServerCallsToSaveIssue++;
                this.nextResponse(request);
            }.bind(this));
        },

        setResponse: function setResponse(response) {
            this.nextResponse = response;
        },

        _makeIssueResponse: function _makeIssueResponse(request, code) {
            request.respond(code, { "Content-Type": "application/json" }, JSON.stringify(createFakeIssue(this.issueId, this.issueKey)));
        },

        _makeHtmlErrorResponse: function _makeHtmlErrorResponse(request, code, htmlResponse) {
            request.respond(code, { "Content-Type": "text/html" }, htmlResponse);
        },

        teardown: function teardown() {
            this.server.restore();
            this.sandbox.restore();
        },

        respond: function respond() {
            this.server.respond();
        },

        getNumberOfServerCallsToLoadIssue: function getNumberOfServerCallsToLoadIssue() {
            return numberOfServerCallsToLoadIssue;
        },

        getNumberOfServerCallsToSaveIssue: function getNumberOfServerCallsToSaveIssue() {
            return numberOfServerCallsToSaveIssue;
        },

        createSavingFieldModel: function createSavingFieldModel() {
            // look at EditIssueController.js#save function to know how to build this fake object
            return {
                getId: function getId() {
                    return 'summary';
                },
                getSaving: function getSaving() {
                    return false;
                },
                getEditing: function getEditing() {
                    return true;
                },
                getInitParams: function getInitParams() {
                    return {
                        summary: "xx"
                    };
                },
                getCurrentParams: function getCurrentParams() {
                    return {
                        summary: "aa"
                    };
                },
                getFieldType: function getFieldType() {
                    return null;
                }
            };
        }
    };

    function createFakeIssue(issueId, issueKey) {
        return {
            issue: {
                id: issueId,
                key: issueKey,
                summary: 'blabla',
                operations: {
                    linkGroups: []
                }
            },
            fields: {
                summary: 'blabla'
            },
            panels: {
                leftPanels: [],
                rightPanels: [],
                infoPanels: []
            },
            errorCollection: {
                errorMessages: [],
                errors: {}
            }
        };
    }

    return FakeServer;
});