/**
 * This module + module jira-agile/rapid/ui/detail/details-field-renderer = ADV before applying inline-edit
 */
define('jira-agile/rapid/ui/detail/legacy/legacy-details-field-renderer', ['require'], function (require) {
    'use strict';

    // When the inline-editable feature comes to the bright side, just delete this file

    var _ = require('underscore');
    var DetailsFieldRenderer = require('jira-agile/rapid/ui/detail/details-field-renderer');
    var DetailsModel = GH.DetailsObjectFactory.getDetailsModel();

    var LegacyDetailsFieldRenderer = {};

    LegacyDetailsFieldRenderer.buildTabs = function (viewData, detailsSections) {
        // add a class to the description tab if there is some content
        var descriptionField = DetailsModel.getViewField('description');
        var isDescriptionHidden = _.isUndefined(descriptionField);
        var hasDescriptionContent = !isDescriptionHidden && !!descriptionField.html;

        // Tabs
        var tabs = [];
        if (detailsSections.length > 0) {
            tabs.push({
                id: 'details',
                title: AJS.I18n.getText('viewissue.subheading.issuedetails'),
                sections: detailsSections,
                viewData: viewData,
                iconFont: 'info'
            });
        }

        tabs.push({
            id: 'description',
            title: AJS.I18n.getText('gh.rapid.detail.description'),
            sections: [{ fields: DetailsModel.getFieldsForSection('description') }],
            hasContent: hasDescriptionContent,
            viewData: viewData,
            iconFont: 'details'
        });

        tabs.push({
            id: 'comments',
            title: AJS.I18n.getText('gh.rapid.comment.label'),
            titleCount: viewData.comments ? viewData.comments.length : 0,
            hasTitleCount: true,
            comments: true,
            canCreateComment: viewData.canCreateComment,
            viewData: viewData,
            iconFont: 'comment'
        });

        tabs.push({
            id: 'attachments',
            title: AJS.I18n.getText('common.concepts.attachments.files'),
            titleCount: viewData.attachments.totalCount,
            hasTitleCount: true,
            attachments: viewData.attachments,
            canCreateAttachment: DetailsModel.hasIssueOperation('attach-file'),
            iconFont: 'attachment'
        });

        // GHS-6791 - if Description is hidden in Field Configuration, remove tab entirely
        if (isDescriptionHidden) {
            delete tabs[1];
            tabs = _.compact(tabs);
        }

        this.addSubtaskTab(tabs, viewData);

        // third party tabs
        if (viewData.tabs && viewData.tabs.thirdPartyTabs && viewData.tabs.thirdPartyTabs.length > 0) {

            var tabData = viewData.tabs.thirdPartyTabs;

            _.each(tabData, function (tabInstance) {
                //
                // The rule for now is that IF they don't have an icon we are NOT going to show them.
                // We may revisit this in the future but for now No Icon?  No Soup for You!
                //
                if (tabInstance.iconURL || tabInstance.iconFont) {
                    tabs.push({
                        id: tabInstance.providerKey.replace(/\./g, '-').replace(/:/g, '-'),
                        title: tabInstance.label,
                        titleCount: tabInstance.titleCount,
                        toolTip: tabInstance.toolTip,
                        hasTitleCount: !_.isUndefined(tabInstance.titleCount),
                        thirdPartyTab: true,
                        html: tabInstance.html,
                        iconURL: tabInstance.iconURL,
                        iconFont: tabInstance.iconFont
                    });
                }
            });
        }
        return tabs;
    };

    LegacyDetailsFieldRenderer.renderEstimationAndTimeTracking = function (viewData, detailHead) {
        this.renderPrimaryStatistics(viewData, detailHead);
    };

    /**
     * Renders an entire 'module' (grouping) of fields
     * @param viewData the view data of the current issue
     * @param detailContainer is the detail view container
     * @param detailTabsContainer a list of fields which will be rendered inside this module
     * @param tabs list of tab data to be rendered
     * @return the DOM element of the entire module structure (to be appended back into the issueFields)
     */
    LegacyDetailsFieldRenderer.renderTabs = function (viewData, detailContainer, detailTabsContainer, tabs) {
        // render tab structure
        var tabStructure = AJS.$(GH.tpl.detailview.renderTabs({
            tabs: tabs
        }));
        var tabMenu = AJS.$(GH.tpl.detailview.renderTabMenu({
            tabs: tabs
        }));
        detailContainer.append(tabMenu);
        detailTabsContainer.append(tabStructure);

        // render fields into tabs
        _.each(tabs, function (tab) {
            // get a reference to the container for fields within this module
            var tabPane = tabStructure.find('#ghx-tab-' + tab.id);
            if (tab.sections) {
                this.renderSections(tab, tabPane);
            } else if (tab.comments) {
                this.renderComments(tab, tabPane);
            } else if (tab.attachments) {
                this.renderAttachments(tab, tabPane);
            } else if (tab.subtasks) {
                this.renderSubtasks(tab, tabPane);
            } else if (tab.thirdPartyTab) {
                this.renderThirdPartyTab(tab, tabPane);
            }
        }.bind(this));
    };

    LegacyDetailsFieldRenderer.renderComments = function (tab, tabPane) {
        var $tabTitle = AJS.$(GH.tpl.detailview.renderTabTitle({ tabTitle: tab.title }));
        tabPane.append($tabTitle);
        // comments rendering
        // render the pane contents
        tabPane.append(AJS.$(GH.tpl.detailview.renderCommentsStructure({
            comments: tab.viewData.comments,
            totalComments: tab.viewData.totalComments,
            canCreateComment: tab.canCreateComment
        })));
    };

    LegacyDetailsFieldRenderer.renderAttachments = function (tab, tabPane) {
        var $tabTitle = AJS.$(GH.tpl.detailview.renderTabTitle({ tabTitle: tab.title }));
        tabPane.append($tabTitle);
        tabPane.append(AJS.$(GH.tpl.detailview.renderAttachments({
            attachments: tab.attachments,
            canCreateAttachment: tab.canCreateAttachment
        })));
    };

    LegacyDetailsFieldRenderer.renderSubtasks = function (tab, tabPane) {
        var $tabTitle = AJS.$(GH.tpl.detailview.renderTabTitle({ tabTitle: tab.title }));
        tabPane.append($tabTitle);
        tabPane.append(this.renderSubtaskAsHtmlNode(tab));
    };

    LegacyDetailsFieldRenderer.renderThirdPartyTab = function (tab, tabPane) {
        var $tabTitle = AJS.$(GH.tpl.detailview.renderTabTitle({ tabTitle: tab.title }));
        tabPane.append($tabTitle);
        tabPane.append(AJS.$(tab.html));
    };

    /**
     * Prepares and appends the primary statistic information for the Detail View Header. The presentation may change after
     * editing the primary statistic field, so we need to be able to invoke this when an issue is updated.
     *
     * @param viewData
     * @param detailHead
     */
    LegacyDetailsFieldRenderer.renderPrimaryStatistics = function (viewData, detailHead) {
        var primaryStatisticField = DetailsModel.getPrimaryEstimateStatisticField();
        var trackingStatisticField = DetailsModel.getPrimaryTrackingStatisticField();
        var $detailStatisticGroup = detailHead.find('.ghx-statistic-group');

        var renderStatFn = function (theField, label, statType) {
            if (theField) {
                var fieldToRender = _.extend({}, theField, {
                    tooltip: theField.label,
                    label: label
                });
                var $statisticDom = this.renderField(viewData, fieldToRender);
                var $detailStatisticContainer = $detailStatisticGroup.find('.js-' + statType);
                $detailStatisticContainer.empty().append($statisticDom);

                // if the field is "empty" then we add an extra class to the container to call out the editing of it.
                if (_.isUndefined(theField.text)) {
                    $detailStatisticContainer.addClass('ghx-empty');
                } else {
                    $detailStatisticContainer.removeClass('ghx-empty');
                }
            } else {
                $detailStatisticGroup.find('.js-' + statType).remove();
            }
        }.bind(this);

        if (!primaryStatisticField && !trackingStatisticField) {
            // no statistics - empty the whole group
            $detailStatisticGroup.empty();
        } else {
            renderStatFn(primaryStatisticField, AJS.I18n.getText('gh.issue.estimate'), 'estimate');

            // if no tracking them remove remaining-group
            if (!trackingStatisticField) {
                $detailStatisticGroup.find('.ghx-remaining-group').remove();
            } else {
                renderStatFn(trackingStatisticField, AJS.I18n.getText('gh.issue.remaining'), 'remaining');
            }
        }
    };

    LegacyDetailsFieldRenderer.renderTimeTrackingDialogFields = function (viewData, $dialogContents) {
        var timeTrackingFields = DetailsModel.getSecondaryTrackingStatisticFields();

        var parentRemainingEstimate = _.find(timeTrackingFields, function (field) {
            return field.id === "timeestimate";
        });
        // fix label of remaining estimate
        parentRemainingEstimate = _.extend({}, parentRemainingEstimate, {
            label: AJS.I18n.getText('gh.rapid.detail.view.fields.remainingestimate.parent')
        });

        var subTasksRemainingEstimate = _.find(timeTrackingFields, function (field) {
            return field.id === 'aggregatetimeestimate_subtasks';
        });

        var $parentEstimateField = this.renderField(viewData, parentRemainingEstimate);
        var $subTasksEstimateField = this.renderField(viewData, subTasksRemainingEstimate);
        $dialogContents.find('.js-parent-remaining').empty().append($parentEstimateField);
        $dialogContents.find('.js-subs-remaining').empty().append($subTasksEstimateField);

        // add/remove the empty class on our parentRemainingEstimate field
        if (_.isUndefined(parentRemainingEstimate.text)) {
            $dialogContents.find('dt.ghx-fieldname-timeestimate').parent('dl').addClass('ghx-empty');
        } else {
            $dialogContents.find('dt.ghx-fieldname-timeestimate').parent('dl').removeClass('ghx-empty');
        }
    };

    return _.extend(DetailsFieldRenderer, LegacyDetailsFieldRenderer);
});