GH.TimeTrackingInlineDialog = {};

/**
 * Keep track of the time tracking inline dialog
 */
GH.TimeTrackingInlineDialog.model = {
    shouldCloseLater: undefined,
    isOpen: false,
    dialog: null
};

GH.TimeTrackingInlineDialog.setDialog = function (dialog) {
    GH.TimeTrackingInlineDialog.model.dialog = dialog;
};

GH.TimeTrackingInlineDialog.getDialog = function () {
    return GH.TimeTrackingInlineDialog.model.dialog;
};

GH.TimeTrackingInlineDialog.setIsOpen = function (isOpen) {
    GH.TimeTrackingInlineDialog.model.isOpen = isOpen;
};

GH.TimeTrackingInlineDialog.getIsOpen = function () {
    return GH.TimeTrackingInlineDialog.model.isOpen;
};

GH.TimeTrackingInlineDialog.setShouldCloseLater = function (shouldCloseLater) {
    GH.TimeTrackingInlineDialog.model.shouldCloseLater = shouldCloseLater;
};

GH.TimeTrackingInlineDialog.getShouldCloseLater = function () {
    return GH.TimeTrackingInlineDialog.model.shouldCloseLater;
};

GH.TimeTrackingInlineDialog.init = function () {
    // register click handler for trigger
    AJS.$(document).delegate('dd.ghx-fieldname-aggregatetimeestimate', 'click', GH.TimeTrackingInlineDialog.show);

    // register inline dialog hacks
    GH.InlineDialog.registerInlineDialogHacks('detailview-timetracking', { validateClickToCloseFn: GH.TimeTrackingInlineDialog.shouldCloseDialogHandler });
};

GH.TimeTrackingInlineDialog.show = function () {
    if (GH.TimeTrackingInlineDialog.getIsOpen()) {
        return;
    }

    var dialogOpts = {
        initCallback: function initCallback() {
            // register with TimeTrackingInlineDialog that the dialog is now open
            GH.TimeTrackingInlineDialog.setIsOpen(true);
        },
        hideCallback: function hideCallback() {
            // register with TimeTrackingInlineDialog that the dialog is now closed
            GH.TimeTrackingInlineDialog.setIsOpen(false);

            // additionally, we want to remove our dialog from the DOM
            GH.InlineDialog.remove('detailview-timetracking');
            GH.TimeTrackingInlineDialog.setDialog(null);
            GH.TimeTrackingInlineDialog.setShouldCloseLater(false);
            GH.TimeTrackingInlineDialog.setIsOpen(false);
        },
        hideDelay: 60000,
        fadeTime: 0,
        noBind: true
    };

    var dialog = GH.InlineDialog.create('detailview-timetracking', 'dd.ghx-fieldname-aggregatetimeestimate', GH.TimeTrackingInlineDialog.renderDialog, dialogOpts);
    GH.TimeTrackingInlineDialog.setDialog(dialog);
    GH.TimeTrackingInlineDialog.setShouldCloseLater(false);
    dialog.show();
};

GH.TimeTrackingInlineDialog.renderDialog = function (contents, trigger, showPopup) {
    var $content = AJS.$(GH.tpl.detailview.renderTimeTrackingInlineDialog());
    GH.DetailsObjectFactory.getDetailsFieldRenderer().renderTimeTrackingDialogFields(GH.DetailsObjectFactory.getDetailsModel().viewData, $content);
    contents.html($content);

    // register the sigma click handler
    var subsAggregateDd = contents.find('.js-subs-remaining dd');
    subsAggregateDd.addClass('ghx-clickable').click(function () {
        // switch over to the subtasks tab
        GH.DetailsView.setTab('ghx-tab-subtasks');

        // try to close
        var canClose = GH.TimeTrackingInlineDialog.shouldCloseDialogHandler();
        if (canClose) {
            GH.TimeTrackingInlineDialog.getDialog().hide();
        }
    });

    showPopup();
};

GH.TimeTrackingInlineDialog.shouldCloseDialogHandler = function () {
    var shouldCloseImmediately = GH.DetailsFieldEdit.getEditingCount() === 0;
    if (!shouldCloseImmediately) {
        // its possible that we are editing and have not submitted yet, OR that we have submitted and an error came back
        // need to register intent to close dialog IF edit is successful
        GH.TimeTrackingInlineDialog.setShouldCloseLater(true);
    }
    return shouldCloseImmediately;
};