GH.Dialogs.AddColumn = {};

GH.Dialogs.AddColumn.EVENT_COLUMN_ADDED = "columnAdded";

GH.Dialogs.AddColumn.statusCategoryPicker = null;
GH.Dialogs.AddColumn.statusNameChangedTimeout = null;

(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.Dialogs.AddColumn.analytics = new AnalyticsTracker('gh.config.add.column.dialog.change');
})();

GH.Dialogs.AddColumn.showDialog = function(rapidViewId, alsoAddStatus) {
    var model = {
        rapidViewId : rapidViewId,
        alsoAddStatus : alsoAddStatus
    };

    GH.Dialogs.AddColumn.renderDialog(model);
    GH.Dialogs.AddColumn.analytics.trigger("start"); // SAFE
};

/**
 * Renders the "add column" dialog
 */
GH.Dialogs.AddColumn.renderDialog = function(model) {
    // cancel callback
    var cancelFn = function() {
        GH.Dialogs.AddColumn.analytics.trigger("cancel"); // SAFE
    };

    // create the dialog
    var dialog = GH.Dialogs.AddColumn.dialog = GH.Dialog.create({
        width : 575,
        height : 200,
        id : 'ghx-dialog-add-column',
        onCancelFn: cancelFn
    });
    dialog.addHeader(AJS.I18n.getText('gh.rapid.config.workflow.add.column.dialog.title'));
    dialog.addPanel('', 'panel');

    var $page = AJS.$(GH.tpl.dialogs.addcolumn.renderAddColumnDialog({}));
    dialog.getCurrentPanel().html($page);
    var submitFunction = function() {
        dialog.disableControls();
        GH.Dialogs.AddColumn.submit(dialog, model);
        return false;
    };
    dialog.addButton(AJS.I18n.getText('gh.rapid.config.workflow.add.column.dialog.submit.label'), submitFunction, 'aui-button');
    // make sure that hitting Enter submits this form and not something else on the page
    $page.submit(submitFunction);
    GH.Dialog.addCancelButton(dialog);

    GH.Dialogs.AddColumn.registerStatusCategoryControls();

    AJS.$('.aui-dialog').addClass('ghx-dialog');

    dialog.show();
    AJS.$('.aui-blanket').empty();

    // give focus to first input element
    AJS.$('#ghx-column-name').focus();
};

/**
 * Submit the dialog
 */
GH.Dialogs.AddColumn.submit = function(dialog, model) {
    clearTimeout(GH.Dialogs.AddColumn.statusNameChangedTimeout);

    // create the data we send to the server
    var columnName = AJS.$('#ghx-column-name').val();
    var statusCategory = AJS.$('#ghx-status-category-picker').val();
    var data = {
        rapidViewId: model.rapidViewId,
        name: AJS.$.trim(columnName),
        alsoAddStatus: model.alsoAddStatus,
        statusCategoryId: parseInt(statusCategory, 10) || GH.StatusCategoryPicker.defaultStatusCategoryId
    };

    GH.Ajax.post({
        url: '/rapidviewconfig/columns',
        data: data,
        errorContextMap: {
            'name': '#ghx-column-name'
        }
    })
        .done(function(result) {
            // analytics for state change and also meta data
            GH.Dialogs.AddColumn.analytics.trigger("complete"); // SAFE

            // close our dialog
            dialog.dispose();

            // tell parties about the success
            AJS.$(GH).trigger(GH.Dialogs.AddColumn.EVENT_COLUMN_ADDED, result.success);
        })
        .fail(function() {
            GH.Dialogs.AddColumn.dialog.updateHeight();
            dialog.enableControls();
        });
};

/**
 * Triggered when the column name field changes on keypress/input depending on browser
 */
GH.Dialogs.AddColumn.handleColumnNameChanged = function() {
    var val = AJS.$("#ghx-column-name").val() || "";
    var newColumnName = AJS.$.trim(val.toLowerCase());

    var result;
    if (!val) {
        result = AJS.$.Deferred().resolve([]);
    } else {
        result = AJS.$.get(GH.Ajax.buildBareRestUrl("/rest/api/2/status"));
    }

    // fetch the existing statuses from JIRA
    result.done(function(statuses) {
        var existingStatus = _.find(statuses, function(status) {
            return status.name.toLowerCase() === newColumnName;
        });
        if (existingStatus) {
            GH.Dialogs.AddColumn.statusCategoryPicker.disableWithValue(existingStatus.statusCategory.id);
            GH.Dialogs.AddColumn.addStatusExistsErrors();
        } else {
            GH.Dialogs.AddColumn.statusCategoryPicker.enableWithValueIfDisabled(GH.StatusCategoryPicker.defaultStatusCategoryId);
            GH.Dialogs.AddColumn.clearErrors();
        }
    });
};

/**
 * Tell the user that the category canot be changed because it has already been defined for the provided column (status)
 * name
 */
GH.Dialogs.AddColumn.addStatusExistsErrors = function() {
    AJS.$("#js-status-category-error").text(
        AJS.I18n.getText('gh.rapid.config.workflow.add.status.dialog.status.category.defined')
    );
};

/**
 * Replace any error messags with the default status category description
 */
GH.Dialogs.AddColumn.clearErrors = function() {
    AJS.$("#js-status-category-error").text(
        AJS.I18n.getText('gh.rapid.config.workflow.add.status.dialog.status.category.description')
    );
};

/**
 * Category Single Select for JIRA status colours
 */
GH.Dialogs.AddColumn.registerStatusCategoryControls = function() {
    GH.Dialogs.AddColumn.fetchStatusCategoryConfig().done(function(isEnabled) {
        if (isEnabled) {
            GH.Dialogs.AddColumn.renderStatusCategoryPicker().done(function() {
                GH.Dialogs.AddColumn.dialog.updateHeight();
            });
        }
    });
};

/**
 * Fetch the status data from jira, populate the select and render the picker
 */
GH.Dialogs.AddColumn.renderStatusCategoryPicker = function() {
    return AJS.$.get(GH.Ajax.buildBareRestUrl('/rest/api/2/statuscategory')).then(function(data) {
        // Don't allow selection of the 'No Category' status category.
        var categories = _.reject(data, function(category) { return category.key === "undefined" });

        AJS.$("#js-status-category-picker-container").html(GH.tpl.dialogs.createstatus.renderCategoryPicker());
        GH.Dialogs.AddColumn.bindColumnNameEvents();
        GH.Dialogs.AddColumn.statusCategoryPicker = GH.StatusCategoryPicker.build({
            element: AJS.$("#ghx-status-category-picker"),
            statusCategories: categories
        });
    });
};

/**
 * Get the availability of status categories
 * @returns jQuery deferred with resulting indicating whether or not status categories are available in JIRA
 */
GH.Dialogs.AddColumn.fetchStatusCategoryConfig = function() {
    return AJS.$.get(GH.Ajax.buildBareRestUrl('/rest/api/2/status')).andThen(function(result) {
        return _.find(result, function(status) {
            return _.isObject(status.statusCategory);
        });
    });
};

/**
 * Listen for the input/keypress events on the column name field
 */
GH.Dialogs.AddColumn.bindColumnNameEvents = function() {
    var $columnName = AJS.$("#ghx-column-name");

    var inputEventSupported = GH.RapidBoard.Browsers.isInputEventSupported();
    $columnName.on(inputEventSupported ? 'input' : 'keypress', function() {
        clearTimeout(GH.Dialogs.AddColumn.statusNameChangedTimeout);
        GH.Dialogs.AddColumn.statusNameChangedTimeout = setTimeout(GH.Dialogs.AddColumn.handleColumnNameChanged, 275);
    });

};