AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    module("Ajax requests", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
            GH.Dialog.undim();
            GH.Notification.clear();
        }
    });

    test("showDialog: Successful Ajax request renders the dialog", sinon.test(function() {
        this.stub(GH.Dialogs.ConvertWorkflow, "renderDialog");

        GH.Test.respondToGetWith200(this, '/workflow/convert.json', {});

        GH.Dialogs.ConvertWorkflow.showDialog();

        this.server.respond();

        ok(GH.Dialogs.ConvertWorkflow.renderDialog.called, "Called render dialog method");
    }));

    test("showDialog: Failed request undims the page", sinon.test(function() {
        this.stub(GH.Dialogs.ConvertWorkflow, "renderDialog");
        this.stub(GH.Dialog, "undim");

        GH.Test.respondToGetWith500(this, '/workflow/convert.json', {});

        GH.Dialogs.ConvertWorkflow.showDialog();

        this.server.respond();

        ok(!GH.Dialogs.ConvertWorkflow.renderDialog.called, "Does not call render dialog function on failure");
        ok(GH.Dialog.undim.called);
    }));

    test("submit: Successful AJAX call handles the conversion result", sinon.test(function() {

        this.stub(GH.Dialogs.ConvertWorkflow, "handleConversionResult");

        GH.Test.respondToPostWith200(this, "/workflow/convert.json", {});

        var dialog = {};
        dialog.enableControls = this.stub();

        GH.Dialogs.ConvertWorkflow.submit(dialog, { projectKey: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(GH.Dialogs.ConvertWorkflow.handleConversionResult.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");

    }));

    test("submit: Failed AJAX call enables dialog controls (no specific error handler)", sinon.test(function() {

        this.stub(GH.Dialogs.ConvertWorkflow, "handleConversionResult");

        GH.Test.respondToPostWith500(this, "/workflow/convert.json", {});

        var dialog = {};
        dialog.enableControls = this.stub();

        GH.Dialogs.ConvertWorkflow.submit(dialog, { projectKey: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.enableControls.called, "Called failure method");
        ok(!GH.Dialogs.ConvertWorkflow.handleConversionResult.called, "Did not call success method");
    }));
});