AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    module("loadContent", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
            GH.Dialog.undim();
            GH.Notification.clear();
        }
    });

    test("Successful Ajax request renders the dialog", sinon.test(function() {
        this.stub(GH.Dialogs.ReleaseVersionDialog, "renderDialog");

        GH.Test.respondToGetWith200(this, '/release/model.json', {});

        GH.Dialogs.ReleaseVersionDialog.showDialog();

        this.server.respond();

        ok(GH.Dialogs.ReleaseVersionDialog.renderDialog.called, "Called success method");
    }));

    test("Failed request undims the background", sinon.test(function() {
        this.stub(GH.Dialogs.ReleaseVersionDialog, "renderDialog");
        this.stub(GH.Dialog, "undim");

        GH.Test.respondToGetWith500(this, '/release/model.json', {});

        GH.Dialogs.ReleaseVersionDialog.showDialog();

        this.server.respond();

        ok(!GH.Dialogs.ReleaseVersionDialog.renderDialog.called, "Does not call process function on failure");
        ok(GH.Dialog.undim.called);
    }));

    test("release: Successful AJAX call disposes the dialog", sinon.test(function() {

        GH.Test.respondToPostWith200(this, "/release", {});

        var dialog = GH.Dialogs.ReleaseVersionDialog.dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();
        dialog.disableControls = this.stub();
        dialog.showSpinner = this.stub();

        GH.Dialogs.ReleaseVersionDialog.release({ projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");

    }));

    test("release: Failed AJAX call enables dialog controls)", sinon.test(function() {

        GH.Test.respondToPostWith500(this, "/release", {});

        var dialog = GH.Dialogs.ReleaseVersionDialog.dialog = {};
        dialog.enableControls = this.stub();
        dialog.dispose = this.stub();
        dialog.disableControls = this.stub();
        dialog.showSpinner = this.stub();
        dialog.hideSpinner = this.stub();

        GH.Dialogs.ReleaseVersionDialog.release({ projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.enableControls.called, "Called failure method");
        ok(dialog.hideSpinner.called, "Called failure method");
    }));
});