AJS.test.require(['com.pyxis.greenhopper.jira:gh-rapid-common'], function () {
    function noop() {}

    module('jira-agile/dialog/side-inline', {
        setup: function setup() {
            this.inlineDialogStub = {
                create: sinon.stub()
            };
            this.context = AJS.test.mockableModuleContext();
            this.context.mock('jira-agile/dialog/inline', this.inlineDialogStub);
            this.sidelineDialog = this.context.require('jira-agile/dialog/side-inline');
        }
    });

    test('it should return an inline dialogue', function () {
        var expected = 'some really cool dialogue',
            args = ['someId', noop, noop, {}];
        this.inlineDialogStub.create.returns(expected);

        var result = this.sidelineDialog.create.apply(null, args);

        ok(this.inlineDialogStub.create.calledOnce);
        deepEqual(this.inlineDialogStub.create.args[0], args);
        equal(result, expected);
    });

    test('it should pass on default parameters for gravity, offsetX and offsetY', function () {
        var defaults = {
            gravity: 'w',
            offsetX: 15,
            offsetY: 0
        };
        this.sidelineDialog.create();

        var options = this.inlineDialogStub.create.args[0][3];

        deepEqual(options, defaults);
    });

    test('it should respect overrides', function () {
        var overrides = {
            // have defaults
            gravity: 'is a good move',
            offsetX: 1335,
            offsetY: 220,
            // does not have a default
            anotherKey: 'hey there'
        };
        this.sidelineDialog.create(null, null, null, overrides);

        var options = this.inlineDialogStub.create.args[0][3];

        deepEqual(options, overrides);
    });
});