
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-dates"], function() {
    module("loadContent", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
            GH.Dialog.undim();
            GH.Notification.clear();
        }
    });

    test("Successful Ajax request renders the dialog", sinon.test(function() {
        this.stub(GH.Dialogs.StartSprintDialog, "renderDialog");

        GH.Test.respondToGetWith200(this, "/sprint/2/start", {});

        GH.Dialogs.StartSprintDialog.showDialog(1, 2);

        this.server.respond();

        ok(GH.Dialogs.StartSprintDialog.renderDialog.called, "Called success method");
    }));

    test("Failed request undims the background", sinon.test(function() {
        this.stub(GH.Dialogs.StartSprintDialog, "renderDialog");
        this.stub(GH.Dialog, "undim");

        GH.Test.respondToGetWith500(this, "/sprint/create/model.json", {});

        GH.Dialogs.StartSprintDialog.showDialog();

        this.server.respond();

        ok(!GH.Dialogs.StartSprintDialog.renderDialog.called, "Does not call process function on failure");
        ok(GH.Dialog.undim.called);
    }));

    test("submit: Successful AJAX call disposes the dialog", sinon.test(function() {

        this.stub(GH.Dialogs.StartSprintDialog, "calculateSprintDuration").returns(0);
        GH.Test.respondToPutWith200(this, "/sprint/2/start", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();

        GH.Dialogs.StartSprintDialog.submit(dialog, { sprintId: 2, projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");

    }));

    test("submit: Failed AJAX call enables dialog controls)", sinon.test(function() {

        GH.Test.respondToPostWith500(this, "/sprint/create.json", {});

        var dialog = {};
        dialog.enableControls = this.stub();
        dialog.dispose = this.stub();

        GH.Dialogs.StartSprintDialog.submit(dialog, { projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();
        ok(dialog.enableControls.called, "Called failure method");
    }));


    module("FormControlsSetup", {
        setup: function() {
            var sprintDurations = [
                {value : 3 , text : '3 Days'},
                {value : 7 , text : '1 Week'},
                {value : 14 , text : '2 Weeks'},
                {value : 28 , text : '4 Weeks'},
                {value : "custom" , text : 'Custom'}];
            this.dialog = AJS.$(GH.tpl.dialogs.startsprint.renderStartSprintDialog({
                numIssues : 1,
                defaultName : 'Sprint 1',
                defaultStartDate : "5/Feb/15 5:00 PM",
                defaultEndDate :  "5/Mar/15 5:00 PM",
                showFilteredIssuesWarning : false,
                numNotEstimatedIssues : 0,
                numExtraNotEstimatedIssues : 0,
                snapshotIssuesNotEstimated : null,
                lastIssueNotEstimated : null,
                numNoTrackingEstimateIssues : 0,
                numExtraNoTrackingEstimateIssues : 0,
                snapshotIssuesNoTrackingEstimate : null,
                lastIssueNoTrackingEstimate : null,
                listOfSprintDurations : sprintDurations
            }));
            GH.Dialogs.StartSprintDialog.dateTimePickerFormat = "%e/%b/%y %I:%M %p";
            GH.Dialogs.StartSprintDialog.registerDurationDropdown(this.dialog, sprintDurations);
        }
    });

    test("Form fields set up correctly.", function() {
        equal(this.dialog.find('#ghx-sprint-duration').val(), 28, "Duration dropdown box has correct value selected.");
        equal(this.dialog.find('#ghx-sprint-end-date').prop("disabled"), true, "End date field is disabled.");
    });

    test("Changing start date updates end date appropriately.", function() {
        var startDateField = this.dialog.find('#ghx-sprint-start-date');
        var endDateField = this.dialog.find('#ghx-sprint-end-date');
        var durationField = this.dialog.find('#ghx-sprint-duration');

        startDateField.val("6/Feb/15 5:00 PM").change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());

        startDateField.val("29/Feb/12 5:30 PM").change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());

        startDateField.val("31/Dec/11 5:30 PM").change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());

    });

    test("Changing duration will vary end date appropriately.", function() {
        var startDateField = this.dialog.find('#ghx-sprint-start-date');
        var endDateField = this.dialog.find('#ghx-sprint-end-date');
        var durationField = this.dialog.find('#ghx-sprint-duration');

        durationField.val(7).change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());

        durationField.val(14).change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());

        durationField.val(3).change();
        assertEndDateIsCorrectlySet(durationField.val(), startDateField.val(), endDateField.val());
    });

    test("Changing duration to custom will prevent end date field from automatically updating", function() {
        var startDateField = this.dialog.find('#ghx-sprint-start-date');
        var endDateField = this.dialog.find('#ghx-sprint-end-date');
        var durationField = this.dialog.find('#ghx-sprint-duration');

        durationField.val('custom').change();
        assertEndDateIsCorrectlySet(28, startDateField.val(), endDateField.val());

        startDateField.val("6/Feb/15 5:00 PM").change();
        assertEndDateIsCorrectlySet(27, startDateField.val(), endDateField.val());

        endDateField.val("7/Mar/15 5:00 PM").change();
        assertEndDateIsCorrectlySet(29, startDateField.val(), endDateField.val());
    });


    function assertEndDateIsCorrectlySet(durationVal, startDate, endDate) {
        var diff = GH.Dialogs.StartSprintDialog.calculateSprintDurationExact(startDate, endDate);
        equal(diff, durationVal, "Interval between start and end date is consistent with duration dropdown");
    }

});
