/**
 * Holds global epics related configuration values
 */
GH.EpicConfig = {};

GH.EpicConfig.epicConfig = undefined;

GH.EpicConfig.setEpicConfig = function (data) {
    GH.EpicConfig.epicConfig = data;
};

GH.EpicConfig.getStoryIssueTypeId = function () {
    return GH.EpicConfig.epicConfig.storyIssueTypeId;
};

GH.EpicConfig.getStoryIssueTypeName = function () {
    return GH.EpicConfig.epicConfig.storyIssueTypeName;
};

GH.EpicConfig.getEpicIssueTypeId = function () {
    return GH.EpicConfig.epicConfig.epicIssueTypeId;
};

GH.EpicConfig.getEpicIssueTypeName = function () {
    return GH.EpicConfig.epicConfig.epicIssueTypeName;
};

GH.EpicConfig.getEpicLabelFieldId = function () {
    return GH.EpicConfig.epicConfig.epicLabelFieldId;
};

GH.EpicConfig.getEpicStatusFieldId = function () {
    return GH.EpicConfig.epicConfig.epicStatusFieldId;
};

GH.EpicConfig.getEpicStatusDoneValueId = function () {
    return GH.EpicConfig.epicConfig.epicStatusDoneValueId;
};

GH.EpicConfig.getEpicLinkFieldName = function () {
    return GH.EpicConfig.epicConfig.epicLinkFieldName;
};

GH.EpicConfig.getEpicLinkFieldId = function () {
    return GH.EpicConfig.epicConfig.epicLinkFieldId;
};

/**
 * If we don't have a "Done" value, then we can't mark epics as done
 * @return {Boolean}
 */
GH.EpicConfig.canMarkEpicAsDone = function () {
    return !_.isUndefined(GH.EpicConfig.epicConfig.epicStatusDoneValueId);
};

GH.EpicConfig.getEpicColorFieldId = function () {
    return GH.EpicConfig.epicConfig.epicColorFieldId;
};

// Utilities

/**
 * Returns the string to use when referring to an epic.
 *
 * @param epicLabel the label - may be empty/false
 * @param epicKey the key of the epic
 * @return {String} (not HTML escaped)
 */
GH.EpicConfig.getEpicNameString = function (epicLabel, epicKey) {
    return epicLabel || AJS.I18n.getText('gh.epic.label.unlabelled') + '-' + epicKey;
};