/**
 * Contains the epic data displayed on plan mode
 */
GH.EpicModel = function () {
    this.epicsList = undefined;
    this.canEditEpics = false;
    this.supportsPages = false;
};

/**
 * Sets the projects required by the model to work
 */
GH.EpicModel.prototype.setData = function (epicData) {
    if (!epicData) {
        return;
    }

    this.canEditEpics = !!epicData.canEditEpics;
    this.supportsPages = !!epicData.supportsPages;

    var epics = epicData.epics || [];

    // preprocess the epics
    _.each(epics, GH.EpicModel.prototype._epicPreprocessFn);

    // wrap epics into a list
    this.epicsList = new GH.IssueListModel('epics', epics, GH.VersionController.getVersionModel());
};

/**
 * Function applied to all epic issues
 */
GH.EpicModel.prototype._epicPreprocessFn = function (epic) {
    // set the epic key as epic label where the label is missing
    epic.originalEpicLabel = epic.epicLabel || '';
    epic.epicLabel = GH.EpicConfig.getEpicNameString(epic.epicLabel, epic.key);
};

/**
 * Get the versions stored in this model
 * @return {GH.IssueListModel}
 */
GH.EpicModel.prototype.getEpicList = function () {
    return this.epicsList;
};

/**
 * Get the projects stored in this model
 */
GH.EpicModel.prototype.canUserEditEpics = function () {
    return this.canEditEpics;
};