/**
 * @since 7.4 This class is responsible for rendering KanPlan acknowledge on top of plan/work mode when KanPlan feature is enabled.
 * @since 7.5 Supports ZDU mixed mode regarding new copy for Kanplan phase 2 introduced in 7.5.
 */
define('jira-agile/rapid/ui/kanplan/kanplan-acknowledge', ['require'], function () {

    'use strict';
    // REQUIRES

    var $ = require('jquery');
    var analytics = require('jira/analytics');
    var KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');

    var KanPlanAcknowledge = {};

    KanPlanAcknowledge.init = function () {
        $('#gh').on('click', '.ghx-ack-close', KanPlanAcknowledge.close);
        $('#gh').on('click', '.ghx-ack-open-backlog', KanPlanAcknowledge.openBacklog);
    };

    KanPlanAcknowledge.show = function () {
        KanPlanAcknowledge.hide();
        var $greenHopperContainer = $('#gh');
        if (KanPlanFeatureService.shouldShowAcknowledge()) {
            $greenHopperContainer.prepend(GH.tpl.kanplan.kanplanacknowledge.render({
                learnMoreURL: GH.HelpPaths.getHelpPath('board.kanplan').url,
                isWorkMode: GH.RapidBoard.State.isWorkMode(),
                isEpicsAndVersionsEnabled: KanPlanFeatureService.isEpicsAndVersionsEnabled()
            }));
            $greenHopperContainer.find('.ghx-ack-learn-more').on('click', function () {
                KanPlanFeatureService.sendAnalyticsInfo('jira-software.kanplan.onboarding.acknowledgement.learnmore.click');
            });
        }
    };

    KanPlanAcknowledge.hide = function () {
        $('#gh').find('.ghx-kanplan-ack').remove();
        GH.RapidBoard.ViewController.handleResizeEvent();
    };

    KanPlanAcknowledge.openBacklog = function () {
        if (KanPlanFeatureService.shouldShowKanbanBacklog()) {
            KanPlanFeatureService.sendAnalyticsInfo('jira-software.kanplan.onboarding.acknowledgement.openbacklog.click');
            KanPlanAcknowledge.close().then(function () {
                GH.RapidBoard.ViewController.setMode('plan');
            });
        }
    };

    KanPlanAcknowledge.close = function () {
        var callback = function callback() {
            var eventName;
            if (GH.RapidBoard.State.isWorkMode()) {
                KanPlanFeatureService.acknowledgeDisplayData.isClosedOnWorkMode = true;
                eventName = 'jira-software.kanplan.onboarding.acknowledgement.closedonworkmode';
            } else {
                KanPlanFeatureService.acknowledgeDisplayData.isClosedOnPlanMode = true;
                eventName = 'jira-software.kanplan.onboarding.acknowledgement.closedonplanmode';
            }
            KanPlanFeatureService.sendAnalyticsInfo(eventName);

            KanPlanAcknowledge.hide();
            return KanPlanFeatureService.dismissEpicsOnboardingDialog('both');
        };

        return GH.Ajax.post({ url: '/xboard/plan/kanban/closeAcknowledge?mode=' + GH.RapidBoard.State.data.mode }).done(callback);
    };

    return KanPlanAcknowledge;
});