define('jira-agile/rapid/ui/kanplan/KanPlanConvertDialog', [
    'jquery',
    'underscore',
    'jira/analytics',
    'jira-agile/rapid/ui/kanplan/kan-plan-feature-service',
    'jira-agile/rapid/events',
    'jira/util/formatter',
    'jira/util/strings'
], function ($,
             _,
             Analytics,
             KanPlanFeatureService,
             Events,
             Formatter,
             strings) {

    var ANALYTICS_NAMESPACE = 'jira-software.kanplan.onboarding.convert.';

    var KanPlanConvertDialog = function () {
        new Events(this);
    };

    KanPlanConvertDialog.prototype.setRapidViewId = function (rapidViewId) {
        this.rapidViewId = rapidViewId;
    };

    KanPlanConvertDialog.prototype.setIssuesCount = function (issuesCount) {
        this.issuesCount = issuesCount;
    };

    KanPlanConvertDialog.prototype.setColumnName = function (columnName) {
        this.columnName = columnName;
    };

    KanPlanConvertDialog.prototype.show = function () {
        var callback = function () {
            KanPlanFeatureService.autoConvertKanPlan(this.rapidViewId).done(function () {
                this.trigger(KanPlanConvertDialog.CONVERT_SUCCESS);
            }.bind(this)).fail(function (res) {
                this.stopAction();
                var err = res.error.errors && res.error.errors[0] && res.error.errors[0].message;

                if (!err) {
                    err = Formatter.I18n.getText('gh.error.error');
                }

                if (this.errorMessage) {
                    this.errorMessage.remove(); // remove the previous message
                }

                this.errorMessage = AJS.messages.error('.aui-dialog2-content', {
                    title: Formatter.I18n.getText('gh.rapid.kanplan.onboarding.convert.error.header'),
                    body: '<p>' + err + '</p>',
                    closeable: false
                });
            }.bind(view));

            KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_NAMESPACE + 'confirm', {
                issueCount: this.issuesCount,
                boardId: this.rapidViewId
            });

        }.bind(this);

        var cancelCallback = KanPlanFeatureService.sendAnalyticsInfo.bind(this, ANALYTICS_NAMESPACE + 'cancel', {
            issueCount: this.issuesCount,
            boardId: this.rapidViewId
        }, false);

        var secondaryCallback = function () {

            KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_NAMESPACE + 'configure', {
                issueCount: this.issuesCount,
                boardId: this.rapidViewId
            });

            GH.RapidBoard.gotoRapidViewConfiguration(this.rapidViewId, 'columns');
        }.bind(this);

        var view = createDialogView({
            callback: callback,
            secondaryCallback: secondaryCallback,
            cancelCallback: cancelCallback,
            columnName: this.columnName
        });

        view.show();
    };

    KanPlanConvertDialog.CONVERT_SUCCESS = 'kanplan.convert.success';

    function createDialogView (options) {
        var $dialogElement = $(GH.tpl.kanplan.convertDialog({
            columnName: strings.escapeHtml(options.columnName),
            isEpicsAndVersionsEnabled: KanPlanFeatureService.isEpicsAndVersionsEnabled()
        }));
        var dialog = AJS.dialog2($dialogElement);

        dialog.startAction = function () {
            $dialogElement.find('.aui-button').attr('disabled', 'disabled');
            $dialogElement.find('.aui-dialog2-footer-actions .aui-button-primary').before('<span class="ghx-spinner"/>');
        };

        dialog.stopAction = function () {
            $dialogElement.find('.aui-button').removeAttr('disabled');
            $dialogElement.find('.ghx-spinner').remove();
        };

        $dialogElement.find("#ghx-kanplan-convert-dialog-confirm-button").click(_.compose(dialog.startAction, options.callback));
        $dialogElement.find("#ghx-kanplan-convert-dialog-configure-button").click(options.secondaryCallback);
        $dialogElement.find(".aui-dialog2-header-close").click(options.cancelCallback);

        return dialog;
    };

    return KanPlanConvertDialog;
});