define('jira-agile/rapid/ui/kanplan/KanPlanOnboardingController', ['jira/util/browser', 'jira-agile/rapid/events', 'jira-agile/rapid/ui/kanplan/KanPlanInlineDialogController', 'jira-agile/rapid/ui/kanplan/KanPlanConvertDialog', 'jira-agile/rapid/ui/kanplan/kan-plan-feature-service'], function (Browser, Events, KanPlanInlineDialogController, KanPlanConvertDialog, KanPlanFeatureService) {
    var kanPlanConvertDialog;
    var rapidViewId;

    var KanPlanOnboardingController = {};

    KanPlanOnboardingController.init = function () {
        rapidViewId = GH.RapidBoard.State.getRapidViewId();

        KanPlanInlineDialogController.init();
        KanPlanInlineDialogController.on(KanPlanInlineDialogController.CONTINUE_EVENT, function () {
            kanPlanConvertDialog.show();
        }, this);

        kanPlanConvertDialog = new KanPlanConvertDialog();
        kanPlanConvertDialog.on(KanPlanConvertDialog.CONVERT_SUCCESS, function () {
            KanPlanInlineDialogController.markAsDismissed();
            GH.storage.put('gh.kanplan.onboarding.autoconvert.success.flag', true, true);
            Browser.reloadViaWindowLocation();
        }, this);
        var showSuccessFlag = GH.storage.get('gh.kanplan.onboarding.autoconvert.success.flag', true);
        if (showSuccessFlag) {
            GH.storage.put('gh.kanplan.onboarding.autoconvert.success.flag', false, true);
            // Display link if acknowledgement banner can't be shown
            var shouldLinkToBacklog = !KanPlanFeatureService.shouldShowAcknowledge();
            KanPlanFeatureService.showAutoConvertSuccessFlag(shouldLinkToBacklog);
        }
    };

    /**
     * @param {GH.GridDataModel} model
     */
    KanPlanOnboardingController.update = function (model) {
        // Fix JS Error when rendering work mode in Agile Gadget
        if (!kanPlanConvertDialog) {
            return;
        }
        kanPlanConvertDialog.setRapidViewId(rapidViewId);
        kanPlanConvertDialog.setIssuesCount(model.getColumnIssueCount(model.getFirstColumn().id));
        kanPlanConvertDialog.setColumnName(model.getFirstColumn().name);
        KanPlanInlineDialogController.changeVisibility(model);
    };

    KanPlanOnboardingController.hide = function () {
        KanPlanInlineDialogController.hide();
    };

    return KanPlanOnboardingController;
});