AJS.test.require([
    "com.pyxis.greenhopper.jira:gh-test-common-base",
    "com.pyxis.greenhopper.jira:gh-rapid",
    "com.pyxis.greenhopper.jira:gh-rapid-config",
    "com.atlassian.plugins.helptips.jira-help-tips",
], function () {
    "use strict";

    let formatter = require("jira/util/formatter");
    let KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
    let EpicsInlineDialog = require('jira-agile/rapid/ui/kanplan/KanplanEpicsInlineDialog');

    const ANALYTICS_ON_WORK_MODE = Object.freeze({
        TAKE_ME_THERE: 'jira-software.kanplan.epics.onboarding.on.work.mode.takemethere.clicked',
        NO_THANKS: 'jira-software.kanplan.epics.onboarding.on.work.mode.nothanks.clicked',
        SHOWN: 'jira-software.kanplan.epics.onboarding.on.work.mode.shown',
    });
    const ANALYTICS_ON_PLAN_MODE = Object.freeze({
        OK_GOT_IT: 'jira-software.kanplan.epics.onboarding.on.plan.mode.okgotit.clicked',
        LET_ME_CHANGE_THIS: 'jira-software.kanplan.epics.onboarding.on.plan.mode.letmechangethis.clicked',
        SHOWN: 'jira-software.kanplan.epics.onboarding.on.plan.mode.shown',
    });


    module("KanplanEpicsInlineDialog - plan mode", {
        setup: function() {
            this.commonInit();
        },
        teardown: function() {
            this.sandbox.restore();
        },
        createEpicsInlineDialog,
        commonInit,
        assertAnalyticEvent,
        mode: 'plan',
        epicsCount: 7
    });


    test("Admin should have a link to configuration on backlog", function () {
        this.isBoardAdminStub.returns(true);

        let options = this.dialog.getOptionsForMode();
        strictEqual(options.showCloseButton, true);
    });

    test("Non-admin should not have a link to configuration on backlog", function () {
        let options = this.dialog.getOptionsForMode();
        strictEqual(options.showCloseButton, false);
    });

    test("Should fill the dialog in with proper content for admin", function () {
        const PLAN_TEXT_ADMIN = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.text.admin");

        this.isBoardAdminStub.returns(true);
        let options = this.dialog.getOptionsForMode();
        strictEqual(options.bodyHtml, PLAN_TEXT_ADMIN);
    });

    test("Should fill the dialog in with proper content for non-admin", function () {
        const PLAN_TEXT_ADMIN = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.text.admin");
        const PLAN_TEXT_USER = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.text.user");
        const TEXT_FOR_USERS = PLAN_TEXT_ADMIN.concat('<br/>', PLAN_TEXT_USER);

        let options = this.dialog.getOptionsForMode();
        strictEqual(options.bodyHtml, TEXT_FOR_USERS);
    });

    test("Should do proper action when clicking a close button link", function () {
        this.isBoardAdminStub.returns(true);
        let actionStub = this.sandbox.stub(GH.RapidBoard, 'gotoRapidViewConfiguration');
        this.clock = sinon.useFakeTimers();

        this.dialog.render();
        this.dialog.closeHandler();

        this.clock.tick(1);

        sinon.assert.calledOnce(actionStub);
    });

    /* Analytics for plan mode */
    test("Should send proper analytics on show", function () {
        this.assertAnalyticEvent(ANALYTICS_ON_PLAN_MODE.SHOWN);
    });

    test("Should not send multiple analytics events on show", function () {
        this.assertAnalyticEvent(ANALYTICS_ON_PLAN_MODE.SHOWN);

        this.dialog.render();
        this.dialog.updatePosition();

        this.assertAnalyticEvent(ANALYTICS_ON_PLAN_MODE.SHOWN);
    });

    test("Should send proper analytics when clicking a button", function () {
        this.dialog.render();
        this.dialog.nextHandler();

        this.assertAnalyticEvent(ANALYTICS_ON_PLAN_MODE.OK_GOT_IT, false);
    });

    test("Should send proper analytics when clicking a close button link", function () {
        this.dialog.render();
        this.dialog.closeHandler();

        this.assertAnalyticEvent(ANALYTICS_ON_PLAN_MODE.LET_ME_CHANGE_THIS, false);
    });


    module("KanplanEpicsInlineDialog - work mode", {
        setup: function() {
            this.commonInit();
        },
        teardown: function() {
            this.sandbox.restore();
        },
        createEpicsInlineDialog,
        commonInit,
        assertAnalyticEvent,
        mode: 'work',
        epicsCount: 27
    });

    test("Should do proper action when clicking a button", function () {
        let actionStub = this.sandbox.stub(GH.RapidBoard.ViewController, 'setMode');

        this.dialog.render();
        this.dialog.nextHandler();

        sinon.assert.calledOnce(actionStub);
    });

    /* Analytics for work mode */
    test("Should send proper analytics on show", function () {
        this.assertAnalyticEvent(ANALYTICS_ON_WORK_MODE.SHOWN);
    });

    test("Should send proper analytics when clicking a button", function () {
        this.sandbox.stub(GH.RapidBoard.ViewController, 'setMode');

        this.dialog.render();
        this.dialog.nextHandler();

        this.assertAnalyticEvent(ANALYTICS_ON_WORK_MODE.TAKE_ME_THERE, false);
    });

    test("Should send proper analytics when clicking a close button link", function () {
        this.dialog.render();
        this.dialog.closeHandler();

        this.assertAnalyticEvent(ANALYTICS_ON_WORK_MODE.NO_THANKS, false);
    });


    /* utils */
    function commonInit() {
        this.sandbox = sinon.sandbox.create();
        this.sendAnalyticsStub = this.sandbox.stub(KanPlanFeatureService, 'sendAnalyticsInfo');
        this.dismissEpicsOnboardingStub = this.sandbox.stub(KanPlanFeatureService, 'dismissEpicsOnboardingDialog')
            .returns(AJS.$.when());

        this.dialog = this.createEpicsInlineDialog({
            mode: this.mode,
            epicsCount: this.epicsCount
        });

        this.isBoardAdminStub = this.sandbox.stub(this.dialog, 'isBoardAdmin');
        this.isBoardAdminStub.returns(false);   // the default is "non-admin" user
    }

    function createEpicsInlineDialog(options) {
        return new EpicsInlineDialog(options);
    }

    function assertAnalyticEvent(name, once = true) {
        if (once) {
            sinon.assert.calledOnce(this.sendAnalyticsStub);
        }
        sinon.assert.calledWithMatch(this.sendAnalyticsStub,
            name,
            sinon.match.has('epicsCount', this.epicsCount),
            true,
        )
    }
});