AJS.namespace("GH.PersistentMessages.WelcomeMessage");

/**
 * The message shown after the welcome mat project creation. TODO this is
 * temporary. People are going to change their mind. Tidy this up once everyone
 * agrees where this should be and what it should look like.
 */
GH.PersistentMessages.WelcomeMessage = {};

GH.PersistentMessages.WelcomeMessage.show = function(data) {
    GH.storage.put('gh.welcomeMessage', data, true);
};

GH.PersistentMessages.WelcomeMessage.renderMessage = function() {
    var welcomeResult = GH.storage.get('gh.welcomeMessage', true);
    if (welcomeResult) {
        var body = null;

        // escape names
        welcomeResult.rapidView.name = AJS.escapeHTML(String(welcomeResult.rapidView.name));
        welcomeResult.project.name = AJS.escapeHTML(String(welcomeResult.project.name));

        // which preset did we use
        var renderFn = null;
        if (/kanban/.test(welcomeResult.preset)) {
            if(welcomeResult.sample) {
                renderFn = GH.tpl.board.x.renderWelcomeProjectSampleMessageKanban;
            } else {
                renderFn = GH.tpl.board.x.renderWelcomeProjectMessageKanban;
            }
        } else if (/scrum/.test(welcomeResult.preset)) {
            if(welcomeResult.sample) {
                renderFn = GH.tpl.board.x.renderWelcomeProjectSampleMessageScrum;
            } else {
                renderFn = GH.tpl.board.x.renderWelcomeProjectMessageScrum;
            }
        }

        body = renderFn({
            project : welcomeResult.project,
            rapidView : welcomeResult.rapidView,
            url : AJS.parseUri(window.location.href)
        });

        GH.Notification.showSuccess(body, {
            title: AJS.I18n.getText('gh.rapid.welcome.success.title'),
            timeout: 10000
        });

        // clear the message from storage
        GH.storage.put('gh.welcomeMessage', null, true);
    }
};
