AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common","com.pyxis.greenhopper.jira:gh-rapid"],function(){var e=require("jira-agile/rapid/ui/plan/backlog-model"),s=require("jira-agile/rapid/ui/plan/backlog-statistics"),t=require("jira-agile/rapid/ui/plan/issue-list-model"),a=require("jira-agile/rapid/global-events");a.trigger("pre-initialization"),GH.RapidViewConfig.currentData.data={sprintSupportEnabled:!0},module("BacklogStatistics"),test("module 'jira-agile/rapid/ui/plan/backlog-statistics' exists",function(){ok(s),ok(GH.BacklogStatistics)}),test("Test getAllIssues and getAllIssuesBeforeRankable",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]);e[0].hidden=!0;var a=new t("test",e);a.insertMarker(5,!1);var i=a.getAllIssues();equal(_.keys(i).length,3),equal(i["GHS-1"],e[0]),equal(i["GHS-2"],e[1]),equal(i["GHS-3"],e[2]);var n=a.getOrder(),l=s.getAllIssuesBeforeIndex(i,n,_.indexOf(n,5));deepEqual(l,[]),l=s.getAllIssuesBeforeIndex(i,n,_.indexOf(n,"GHS-1")),deepEqual(l,[]),l=s.getAllIssuesBeforeIndex(i,n,_.indexOf(n,"GHS-2")),deepEqual(l,[e[0]]),l=s.getAllIssuesBeforeIndex(i,n,_.indexOf(n,"GHS-3")),deepEqual(l,[e[0],e[1]]),a.insertMarker(5,"GHS-3"),n=a.getOrder(),l=s.getAllIssuesBeforeIndex(i,n,_.indexOf(n,5)),deepEqual(l,e)}),test("correctly calculates issue stats when all issues are hidden",function(){var e=[GH.IssueTest.createIssueObject({hidden:!0}),GH.IssueTest.createIssueObject({hidden:!0})],a=new t("model",e,new GH.VersionsModel([])),i=s.getIssueListStats(a,!1);equal(i.totalCount,2),equal(i.visibleCount,0),equal(i.allVisible,!1),equal(i.noneVisible,!0),equal(i.hasIssues,!0),equal(i.empty,!1)}),test("correctly calculates issue stats when there are no issues",function(){var e=new t("model",[],new GH.VersionsModel([])),a=s.getIssueListStats(e,!1);equal(a.totalCount,0),equal(a.visibleCount,0),equal(a.allVisible,!0),equal(a.noneVisible,!0),equal(a.hasIssues,!1),equal(a.empty,!0)}),test("correctly calculates issue stats when all issues are visible",function(){var e=[GH.IssueTest.createIssueObject(),GH.IssueTest.createIssueObject()],a=new t("model",e,new GH.VersionsModel([])),i=s.getIssueListStats(a,!1);equal(i.totalCount,2),equal(i.visibleCount,2),equal(i.allVisible,!0),equal(i.noneVisible,!1),equal(i.hasIssues,!0),equal(i.empty,!1)}),test("correctly calculates issue stats when some issues are filtered",function(){var e=[GH.IssueTest.createIssueObject(),GH.IssueTest.createIssueObject(),GH.IssueTest.createIssueObject({hidden:!0})],a=new t("model",e,new GH.VersionsModel([])),i=s.getIssueListStats(a,!1);equal(i.totalCount,3),equal(i.visibleCount,2),equal(i.allVisible,!1),equal(i.noneVisible,!1),equal(i.hasIssues,!0),equal(i.empty,!1)}),test("Calculates total estimate of 0 when there are no issues",function(){e.estimationStatistic={isEnabled:!0,name:"Story Points"};var a=new t("model",[],new GH.VersionsModel([])),i=s.getIssueListEstimateStatistics(a);ok(i.estimate.shown),equal(i.estimate.name,"Story Points"),equal(i.estimate.total.raw,0),equal(i.estimate.visible.raw,0),ok(!i.tracking.shown)}),test("Calculates total estimate when all issues are visible",function(){e.estimationStatistic={isEnabled:!0,name:"Story Points"};var a=[GH.IssueTest.createIssueObjectWithEstimate(3),GH.IssueTest.createIssueObjectWithEstimate(5)],i=new t("model",a,new GH.VersionsModel([])),n=s.getIssueListEstimateStatistics(i);ok(n.estimate.shown),equal(n.estimate.name,"Story Points"),equal(n.estimate.total.raw,8),equal(n.estimate.visible.raw,8),ok(!n.tracking.shown)}),test("Calculates total estimate when some issues are visible",function(){e.estimationStatistic={isEnabled:!0,name:"Story Points"};var a=[GH.IssueTest.createIssueObjectWithEstimate(3),GH.IssueTest.createIssueObjectWithEstimate(5),GH.IssueTest.createIssueObjectWithEstimate(2,{hidden:!0})],i=new t("model",a,new GH.VersionsModel([])),n=s.getIssueListEstimateStatistics(i);ok(n.estimate.shown),equal(n.estimate.name,"Story Points"),equal(n.estimate.total.raw,10),equal(n.estimate.visible.raw,8),ok(!n.tracking.shown)}),test("getAssignedWorkStats aggregates estimate values by assignee",function(){var e=[GH.IssueTest.createIssueObjectWithEstimate(3,{assignee:"a",assigneeName:"Alice"}),GH.IssueTest.createIssueObjectWithEstimate(null,{assignee:"a",assigneeName:"Alice"}),GH.IssueTest.createIssueObjectWithEstimate(null,{assignee:"a",assigneeName:"Alice"}),GH.IssueTest.createIssueObjectWithEstimate(5,{assignee:"b",assigneeName:"Bob"}),GH.IssueTest.createIssueObjectWithEstimate(2,{assignee:"b",assigneeName:"Bob"}),GH.IssueTest.createIssueObjectWithEstimate(2,{assignee:"",assigneeName:""})],a=new t("model",e,new GH.VersionsModel([])),i=s.getAssignedWorkStats(a);strictEqual(i.assigned.length,2,"Two assignees"),strictEqual(i.assigned[0].totalEstimate,7,"Largest total estimate first"),strictEqual(i.assigned[0].issues.length,2,"Issues assigned to the first assignee"),strictEqual(i.assigned[1].totalEstimate,3),strictEqual(i.assigned[1].issues.length,3,"Issues assigned to the second assignee"),strictEqual(i.unassigned.totalEstimate,2,"Total unassigned work"),strictEqual(i.unassigned.issues.length,1,"Unassigned issues")}),test("getAssignedWorkStats sorts assignees alphabetically when total estimate is equal",function(){var e=[GH.IssueTest.createIssueObjectWithEstimate(3,{assignee:"a",assigneeName:"Z"}),GH.IssueTest.createIssueObjectWithEstimate(1,{assignee:"a",assigneeName:"Z"}),GH.IssueTest.createIssueObjectWithEstimate(3,{assignee:"b",assigneeName:"Y"}),GH.IssueTest.createIssueObjectWithEstimate(1,{assignee:"b",assigneeName:"Y"})],a=new t("model",e,new GH.VersionsModel([])),i=s.getAssignedWorkStats(a);strictEqual(i.assigned.length,2,"Two assignees"),strictEqual(i.assigned[0].assignee,"b","Assignees with the same total estimate are sorted alphabetically"),strictEqual(i.assigned[1].assignee,"a","Assignees with the same total estimate are sorted alphabetically")}),test("getAssignedWorkStats ignores hidden issues",function(){var e=[GH.IssueTest.createIssueObjectWithEstimate(3,{assignee:"a",assigneeName:"Alice",hidden:!0}),GH.IssueTest.createIssueObjectWithEstimate(5,{assignee:"b",assigneeName:"Bob"}),GH.IssueTest.createIssueObjectWithEstimate(2,{assignee:"b",assigneeName:"Bob",hidden:!0}),GH.IssueTest.createIssueObjectWithEstimate(2,{assignee:"",assigneeName:""}),GH.IssueTest.createIssueObjectWithEstimate(3,{assignee:"",assigneeName:"",hidden:!0})],a=new t("model",e,new GH.VersionsModel([])),i=s.getAssignedWorkStats(a);strictEqual(i.assigned.length,1,"One assignee after excluding hidden issues"),strictEqual(i.assigned[0].totalEstimate,5,"Total estimate excludes hidden issues"),strictEqual(i.unassigned.totalEstimate,2,'Total estimate excludes hidden issues for "unassigned"'),strictEqual(i.all.totalEstimate,7,'Total estimate excludes hidden issues for "all"')}),test("getAssignedWorkStats includes assignees even if none of their issues are estimated",function(){var e=[GH.IssueTest.createIssueObjectWithEstimate(null,{assignee:"a",assigneeName:"Alice"}),GH.IssueTest.createIssueObject({assignee:"b",assigneeName:"Bob"}),GH.IssueTest.createIssueObject({assignee:"",assigneeName:""})],a=new t("model",e,new GH.VersionsModel([])),i=s.getAssignedWorkStats(a);strictEqual(i.assigned.length,2,"Two assignees"),strictEqual(i.assigned[0].totalEstimate,0,"Total estimate is 0"),strictEqual(i.assigned[1].totalEstimate,0,"Total estimate is 0"),strictEqual(i.unassigned.totalEstimate,0,"Total estimate is 0"),strictEqual(i.all.totalEstimate,0,"Total estimate is 0")}),test("getAssignedWorkStats has totalTrackingEstimate when trackingStatistic is enabled",function(){e.estimationStatistic={isEnabled:!0,name:"Original Time Estimate",renderer:"duration"},e.trackingStatistic.isEnabled=!0;var a=[GH.IssueTest.createIssueObjectWithEstimate(14400,{assignee:"a",assigneeName:"Alice",trackingStatistic:{statFieldValue:{value:7200}}}),GH.IssueTest.createIssueObjectWithEstimate(14400,{assignee:"a",assigneeName:"Alice",trackingStatistic:{statFieldValue:{value:7200}}}),GH.IssueTest.createIssueObjectWithEstimate(14400,{assignee:"b",assigneeName:"Bob"})],i=new t("model",a,new GH.VersionsModel([])),n=s.getAssignedWorkStats(i);strictEqual(n.assigned.length,2,"Two assignees"),strictEqual(n.assigned[0].totalEstimateText,"1d","Total estimate is 1d"),strictEqual(n.assigned[0].totalTrackingEstimateText,"14,400","Total tracking estimate is 4h"),strictEqual(n.assigned[1].totalEstimateText,"4h","Total estimate is 4h")}),test("getAssignedWorkStats does not have totalTrackingEstimate when trackingStatistic is disabled",function(){e.estimationStatistic={isEnabled:!0,name:"Original Time Estimate",renderer:"duration"},e.trackingStatistic.isEnabled=!1;var a=[GH.IssueTest.createIssueObjectWithEstimate(14400,{assignee:"a",assigneeName:"Alice"}),GH.IssueTest.createIssueObjectWithEstimate(14400,{assignee:"a",assigneeName:"Alice"})],i=new t("model",a,new GH.VersionsModel([])),n=s.getAssignedWorkStats(i);strictEqual(n.assigned.length,1,"One assignee"),strictEqual(n.assigned[0].totalEstimateText,"1d","Total estimate is 1d"),ok(!("totalTrackingEstimateText"in n.assigned[0]))}),test("calculateSprintProgress shouldn't calculate hidden issues",function(){var e=[GH.IssueTest.createIssueObjectWithEstimate(1,{hidden:!1}),GH.IssueTest.createIssueObjectWithEstimate(2,{hidden:!1}),GH.IssueTest.createIssueObjectWithEstimate(2,{hidden:!0})],a=new t("model",e,new GH.VersionsModel([])),i=[{statusIds:[1]}],n={isEnabled:!0,typeId:"field",name:"Story Points",renderer:"number"},l=s.calculateSprintProgress(a,i,n);equal(l[0].total.value,3)}),module("calculateStatisticsFieldValue",{setup:function(){var e=[GH.IssueTest.createIssueObject({id:1,hidden:!1}),GH.IssueTest.createIssueObject({id:2,hidden:!1,parentId:1}),GH.IssueTest.createIssueObject({id:3,hidden:!0})];this.issueListModel=new t("model",e,new GH.VersionsModel([]))},teardown:function(){this.issueListModel=null}}),test("calculateStatisticsFieldValue() should filter out subtasks when statisticsConfig is excluding subtasks",function(){var e={typeId:s.EXCLUDE_SUBTASKS_COLUMN_CONSTRAINT},t=s.calculateStatisticsFieldValue(this.issueListModel,e);deepEqual(t,{statisticsFieldTotal:2,statisticsFieldVisible:1,excludeSubtasks:!0,subtasksTotal:1,subtasksVisible:1})}),test("calculateStatisticsFieldValue() should not filter out subtasks when statisticsConfig is not excluding subtasks",function(){var e={typeId:"none"},t=s.calculateStatisticsFieldValue(this.issueListModel,e);deepEqual(t,{statisticsFieldTotal:3,statisticsFieldVisible:2})})});