AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function() {
    var BacklogModel2 = require('jira-agile/rapid/ui/plan/backlog-model2');
    var IssueActions = require('jira-agile/rapid/ui/plan/issue-actions');
    var PlanDragAndDrop = require('jira-agile/rapid/ui/plan/plan-drag-and-drop');

    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    module("Ranking logic");

    test("module 'jira-agile/rapid/ui/plan/issue-actions' exists", function() {
        ok(IssueActions);
        ok(GH.IssueActions);
    });

    test("sendIssuesToBottomOfSprint: calls rank method with last issue key for sprint", sinon.test(function() {

    var issues = GH.IssueTest.issueObjectsFromKeys(["GHS-1", "GHS-2", "GHS-3"]);
    var sprintModel = new GH.SprintModel({ id: "Sprint"}, issues);

    this.stub(PlanDragAndDrop, "rankIssues");

    IssueActions.sendIssuesToBottomOfSprint([1], sprintModel);

    ok(PlanDragAndDrop.rankIssues.called, "Called rankIssues");

    var args = PlanDragAndDrop.rankIssues.args[0];

    deepEqual(args[0], [1], "correctly passed issues to rank");
    equal(args[1], "Sprint", "correctly passed sprint ID");
    equal(args[2], "GHS-3", "correctly passed last issue key");
    equal(args[3], null, "correctly passed no 'next rankable'");
    }));

    test("sendIssuesToTopOfBacklog: calls rank method with first issue key in backlog", sinon.test(function() {

    var issues = GH.IssueTest.issueObjectsFromKeys(["GHS-1", "GHS-2", "GHS-3"]);
    var sprintModel = new BacklogModel2(issues);

    this.stub(PlanDragAndDrop, "rankIssues");

    IssueActions.sendIssuesToTopOfBacklog([1], sprintModel);

    ok(PlanDragAndDrop.rankIssues.called, "Called rankIssues");

    var args = PlanDragAndDrop.rankIssues.args[0];

    deepEqual(args[0], [1], "correctly passed issues to rank");
    equal(args[1], null, "correctly passed nothing for sprint");
    equal(args[2], null, "correctly passed no 'prev rankable'");
    equal(args[3], "GHS-1", "correctly passed first issue key");
    }));

    test("sendIssuesToBottomOfBacklog: calls rank method with last issue key in backlog", sinon.test(function() {

    var issues = GH.IssueTest.issueObjectsFromKeys(["GHS-1", "GHS-2", "GHS-3"]);
    var sprintModel = new BacklogModel2(issues);

    this.stub(PlanDragAndDrop, "rankIssues");

    IssueActions.sendIssuesToBottomOfBacklog([1], sprintModel);

    ok(PlanDragAndDrop.rankIssues.called, "Called rankIssues");

    var args = PlanDragAndDrop.rankIssues.args[0];

    deepEqual(args[0], [1], "correctly passed issues to rank");
    equal(args[1], null, "correctly passed nothing for sprint");
    equal(args[2], "GHS-3", "correctly passed last issue key");
    equal(args[3], null, "correctly passed no 'next rankable'");

    }));

    test("sendIssuesToBacklog: does not provide rank before/after issue key", sinon.test(function() {
        var issues = GH.IssueTest.issueObjectsFromKeys(["GHS-1", "GHS-2", "GHS-3"]);
        var sprintModel = new BacklogModel2(issues);

        this.stub(PlanDragAndDrop, "rankIssues");

        IssueActions.sendIssuesToBacklog([1], sprintModel);

        ok(PlanDragAndDrop.rankIssues.called, "Called rankIssues");

        var args = PlanDragAndDrop.rankIssues.args[0];

        deepEqual(args[0], [1], "correctly passed issues to rank");
        equal(args[1], null, "correctly passed nothing for sprint");
        equal(args[2], null, "correctly passed no 'prev rankable'");
        equal(args[3], null, "correctly passed no 'next rankable'");
    }));

    test("sendIssuesToSprint: does not provide rank before/after issue key", sinon.test(function() {
        var issues = GH.IssueTest.issueObjectsFromKeys(["GHS-1", "GHS-2", "GHS-3"]);
        var sprintModel = new GH.SprintModel({ id: "Sprint"}, issues);

        this.stub(PlanDragAndDrop, "rankIssues");

        IssueActions.sendIssuesToSprint([1], sprintModel);

        ok(PlanDragAndDrop.rankIssues.called, "Called rankIssues");

        var args = PlanDragAndDrop.rankIssues.args[0];

        deepEqual(args[0], [1], "correctly passed issues to rank");
        equal(args[1], "Sprint", "correctly passed sprint ID");
        equal(args[2], null, "correctly passed no 'prev rankable'");
        equal(args[3], null, "correctly passed no 'next rankable'");
    }));
});