AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    module("Fix version");

    test("should return a fix version model given a single id", function () {
        var projectDef = { id: 10900 };
        var version10300 = { id: 10300, name: "R1", sequence: 1, released: false };
        var version10301 = { id: 10301, name: "R2", sequence: 2, released: false };

        var versionPerProject = {};
        versionPerProject[projectDef.id] = [version10300, version10301];
        var fixVersionData = { versionsPerProject: versionPerProject };

        var model = new GH.VersionsModel([projectDef]);
        model.updateRawData(fixVersionData);

        var expected10300 = _.extend(version10300, { project: projectDef });
        var expected10301 = _.extend(version10301, { project: projectDef });

        deepEqual(model.getVersionsForIds([10300]), { "formattedVersions": "R1", "versions": [expected10300] });
        deepEqual(model.getVersionsForIds([10301]), { "formattedVersions": "R2", "versions": [expected10301] });
    });

    test("should return an empty formatted versions and versions array for no fix version", function () {

        var fixVersionData = {
            versionsPerProject: {
                10900: [{ id: 10300, name: "R1", sequence: 1, released: false }, { id: 10301, name: "R2", sequence: 1, released: false }]
            }
        };
        var model = new GH.VersionsModel([]);
        model.updateRawData(fixVersionData);

        deepEqual(model.getVersionsForIds([]), { "formattedVersions": "", "versions": [] });
    });

    test("should return the first unreleased fix version sequentially and display in order, unreleased first", function () {
        // todo: update to use sequence
        var projectDef = { id: 10900 };
        var version10300 = { id: 10300, name: "R1", sequence: 1, released: false };
        var version10301 = { id: 10301, name: "R2", sequence: 2, released: true };
        var version10303 = { id: 10303, name: "R3", sequence: 3, released: true };
        var version10304 = { id: 10304, name: "R4", sequence: 4, released: false };

        var versionPerProject = {};
        versionPerProject[projectDef.id] = [version10300, version10301, version10303, version10304];
        var fixVersionData = { versionsPerProject: versionPerProject };

        var model = new GH.VersionsModel([projectDef]);
        model.updateRawData(fixVersionData);

        var expected10300 = _.extend(version10300, { project: projectDef });
        var expected10301 = _.extend(version10301, { project: projectDef });
        var expected10303 = _.extend(version10303, { project: projectDef });
        var expected10304 = _.extend(version10304, { project: projectDef });

        deepEqual(model.getVersionsForIds([10300, 10301, 10304, 10303]), { "formattedVersions": "R1, R2 (released), R3 (released), R4",
            "versions": [expected10300, expected10301, expected10303, expected10304] });

        deepEqual(model.getVersionsForIds([10301, 10303, 10300, 10304]), { "formattedVersions": "R1, R2 (released), R3 (released), R4",
            "versions": [expected10300, expected10301, expected10303, expected10304] });
    });

    test("ignores unrecognised release versions (e.g. archived", function () {
        var projectDef = { id: 10900 };
        var version10300 = { id: 10300, name: "R1", sequence: 1, released: true };
        var version10301 = { id: 10301, name: "R2", sequence: 2, released: true };

        var versionPerProject = {};
        versionPerProject[projectDef.id] = [version10300, version10301];
        var fixVersionData = { versionsPerProject: versionPerProject };

        var model = new GH.VersionsModel([projectDef]);
        model.updateRawData(fixVersionData);

        var expected10300 = _.extend(version10300, { project: projectDef });

        deepEqual(model.getVersionsForIds([99999]), { "formattedVersions": "", "versions": [] });
        deepEqual(model.getVersionsForIds([10300, 99999]), { "formattedVersions": "R1 (released)", "versions": [expected10300] });
    });

    test("uses first released version if none are unreleased", function () {
        var projectDef = { id: 10900 };
        var version10300 = { id: 10300, name: "R1", sequence: 1, released: true };
        var version10301 = { id: 10301, name: "R2", sequence: 2, released: true };

        var versionPerProject = {};
        versionPerProject[projectDef.id] = [version10300, version10301];
        var fixVersionData = { versionsPerProject: versionPerProject };

        var model = new GH.VersionsModel([{ id: 10900 }]);
        model.updateRawData(fixVersionData);

        var expected10300 = _.extend(version10300, { project: projectDef });
        var expected10301 = _.extend(version10301, { project: projectDef });

        deepEqual(model.getVersionsForIds([10300, 10301]), {
            "formattedVersions": "R1 (released), R2 (released)",
            "versions": [expected10300, expected10301] });
        deepEqual(model.getVersionsForIds([10301, 10300]), {
            "formattedVersions": "R1 (released), R2 (released)",
            "versions": [expected10300, expected10301] });
    });

    test("creates a usable array of versions with project names", function () {

        var fixVersionData = {
            versionsPerProject: {
                10900: [{ id: 10300, name: "R1", sequence: 1, released: false }, { id: 10301, name: "R2", sequence: 2, released: false }]
            }
        };

        var projectData = [{ id: 10900, name: "Project" }, { id: 10901, name: "Project" }];

        var model = new GH.VersionsModel(projectData);
        model.updateRawData(fixVersionData);

        var versionList = model.getUnreleasedVersionList();

        equal(versionList.length, 2);
        equal(versionList[0].id, 10300);
        equal(versionList[0].name, "R1");
        equal(versionList[0].project.id, 10900);
        equal(versionList[0].project.name, "Project");

        equal(versionList[1].id, 10301);
        equal(versionList[1].name, "R2");
        equal(versionList[1].project.id, 10900);
        equal(versionList[1].project.name, "Project");
    });

    test("doesn't include unreleased versions in the list", function () {
        var fixVersionData = {
            versionsPerProject: {
                10900: [{ id: 10300, name: "R1", sequence: 1, released: true }, { id: 10301, name: "R2", sequence: 2, released: false }]
            }
        };

        var model = new GH.VersionsModel([]);
        model.updateRawData(fixVersionData);

        var versionList = model.getUnreleasedVersionList();

        equal(versionList.length, 1);
    });

    test("DevStatus release report link should be available", function () {
        var fixVersionData = {
            isLinkToDevStatusVersionAvailable: true,
            versionsPerProject: {}
        };

        var model = new GH.VersionsModel([]);
        model.updateRawData(fixVersionData);

        equal(model.isLinkToDevStatusVersionAvailable(), true);
    });
});