AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    const SwimlaneView = require('jira-agile/rapid/ui/work/swimlane-view');

    module("SwimlaneView");

    test("renderActiveSprintEmptyMsg: SwimlaneView.activeSprintEmptyMsg should be defined", sinon.test(function() {

        this.stub(GH.UserData, "hasUser").returns(false);
        this.stub(GH.WorkControls, "hasSprints").returns(false);
        this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);

        SwimlaneView.renderActiveSprintEmptyMsg();

        ok(!_.isUndefined(GH.WorkController.activeSprintEmptyMsg), "Active sprint empty message should be defined");
    }));

    test("renderActiveSprintEmptyMsg: The second line of message should NOT has hidden class when canEdit is true", sinon.test(function() {

            this.stub(GH.UserData, "hasUser").returns(true);
            this.stub(GH.WorkControls, "hasSprints").returns(true);
            this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);
            var deferred = new AJS.$.Deferred();

            this.stub(GH.RapidViewConfig, "fetchConfiguration").returns(deferred.promise());

            SwimlaneView.renderActiveSprintEmptyMsg();

            deferred.resolve({canEdit: true});

            ok(!GH.WorkController.activeSprintEmptyMsg.secondLineView.hasClass("hidden"), "The link should be visible");
    }));

    test("renderActiveSprintEmptyMsg: The second line of message should has hidden class when canEdit is false", sinon.test(function() {

        this.stub(GH.UserData, "hasUser").returns(true);
        this.stub(GH.WorkControls, "hasSprints").returns(true);
        this.stub(GH.WorkControls, "getActiveQuickFilterCount").returns(0);
        var deferred = new AJS.$.Deferred();

        this.stub(GH.RapidViewConfig, "fetchConfiguration").returns(deferred.promise());

        SwimlaneView.renderActiveSprintEmptyMsg();

        deferred.resolve({canEdit: false});

        ok(GH.WorkController.activeSprintEmptyMsg.secondLineView.hasClass("hidden"), "The link should NOT be visible");
    }));
});