AJS.namespace('GH.RapidBoard.WorkSubnavigatorContextProvider');

/* global AJS */
define('jira-agile/subnavigator/work-subnavigator-context-provider', [
    'jquery',
    'underscore',
    'jira-agile/rapid/work/work-controls'
], function(
    $,
    _,
    WorkControls
) {

    var ALL_SPRINTS_FILTER_ID = 'all';
    var SPRINT_FILTER_CHANGED_EVENT = 'sprintFilterChange';
    var kanbanListItem = {
        id: 0,
        label: AJS.I18n.getText('gh.rapid.subnavigator.work.kanban.header')
    };
    var noActiveSprintListItem = {
        id: 0,
        label: AJS.I18n.getText('gh.rapid.subnavigator.work.scrum.header.no.sprint')
    };

    var contextProvider = {
        hasSubnavigator: function() {
            return true;
        },

        header: function() {
            return WorkControls.rapidViewConfig.name;
        },
        getSprintGoal() {

            if(!WorkControls.sprintfilters.hasSprints()){
                return;
            }

            let goal;
            if(WorkControls.sprintfilters.hasParallelActiveSprints()) {
                var activeSprintId = WorkControls.sprintfilters.getActiveSprintFilters()[0];
                // Active sprint id is undefined when filter is "All sprints"
                goal = activeSprintId? WorkControls.sprintfilters.getSprintById(activeSprintId).goal : '';
            }
            else {
                // There is only one active sprint
                goal = WorkControls.sprintfilters.getSprintData()[0].goal;
            }
            return  goal;
        },

        itemList: function() {
            if (this._isKanban()) {
                return [kanbanListItem];
            }
            // else Scrum
            var sprints = _.map(this._getSprints(), function(sprint) {
                return {
                    id: sprint.id.toString(),
                    label: sprint.name
                };
            });

            if (sprints.length === 0) {
                return [noActiveSprintListItem];
            }
            else if (sprints.length === 1) {
                return sprints;
            }
            // else multiple sprints
            return [sprints, [{
                id: ALL_SPRINTS_FILTER_ID,
                label: AJS.I18n.getText('gh.sprint.customfield.dropdown.all')
            }]];
        },

        onLoad: function() {},

        selectedItem: function() {
            if (this._isKanban()) {
                return kanbanListItem.id;
            }
            // else Scrum
            var selection = WorkControls.sprintfilters.getActiveSprintFilters()[0];
            if (selection) {
                return selection.toString();
            }

            var sprintCount = this._getSprints().length;
            if (sprintCount === 0) {
                return noActiveSprintListItem.id;
            }
            else if (sprintCount === 1) {
                return WorkControls.sprintfilters.getSprintData()[0].id.toString();
            }
            // else multiple sprints
            return ALL_SPRINTS_FILTER_ID;
        },

        selectionHandler: function(selectedSprintId) {
            var targetFilter = (selectedSprintId === ALL_SPRINTS_FILTER_ID) ?
                WorkControls.sprintfilters.getActiveSprintFilters()[0] :
                parseInt(selectedSprintId, 10);

            WorkControls.sprintfilters.toggleActiveSprintFilter(targetFilter);
            $(WorkControls.sprintfilters).trigger(SPRINT_FILTER_CHANGED_EVENT);
        },

        getChangeViewText: function() {
            return  AJS.I18n.getText('gh.rapid.subnavigator.work.scrum.sprint.picker');
        },

        analyticEvent: function(itemId, initialLoad) {
            return {
                name: 'jira.project.sidebar.sprint.select',
                data: {
                    sprintId: itemId,
                    initialLoad: initialLoad
                }
            };
        },

        _getSprints: function() {
            return WorkControls.sprintfilters.getSprintData();
        },

        _isKanban: function() {
            return !WorkControls.rapidViewConfig.sprintSupportEnabled;
        }
    };

    return contextProvider;
});

AJS.namespace('GH.RapidBoard.WorkSubnavigatorContextProvider', null, require('jira-agile/subnavigator/work-subnavigator-context-provider'));
