AJS.test.require(['com.pyxis.greenhopper.jira:gh-rapid', 'com.pyxis.greenhopper.jira:subnavigator-test'], function() {

    var workSubnavigatorContextProvider;
    var mockWorkControls = {
        rapidViewConfig: {
            name: "board name"
        },
        activeSprintFilterId: 0,
        hasParallelSprints: false,
        sprints: [{id: 1, goal: 'This is a goal'}],
        sprintfilters: {
            hasSprints(){
                return !!mockWorkControls.sprints.length;
            },
            getActiveSprintFilters (){
                return [mockWorkControls.activeSprintFilterId];
            }
            ,
            getSprintData() {
                return mockWorkControls.sprints;
            },
            getSprintById(){
                return mockWorkControls.sprints[0];
            },
            hasParallelActiveSprints(){
                return mockWorkControls.hasParallelSprints;
            }
        }
    };

    var context = AJS.test.mockableModuleContext();

    context.mock('jira-agile/rapid/work/work-controls', mockWorkControls);
    workSubnavigatorContextProvider = context.require('jira-agile/subnavigator/work-subnavigator-context-provider');

    module('Subnavigator.tests', {
        setup: function() {
            sinon.stub(workSubnavigatorContextProvider, '_isKanban');
            sinon.stub(workSubnavigatorContextProvider, '_getSprints');
        },
        teardown: function() {
            workSubnavigatorContextProvider._isKanban.restore();
            workSubnavigatorContextProvider._getSprints.restore();
        }
    });

    test('header should be board name', function() {
        var boardName = mockWorkControls.rapidViewConfig.name;
        var header = workSubnavigatorContextProvider.header();

        equal(header, boardName, 'Expected header to be board name');
    });

    var kanbanListItem = {
        id: 0,
        label: AJS.I18n.getText('gh.rapid.subnavigator.work.kanban.header')
    };
    var noActiveSprintListItem = {
        id: 0,
        label: AJS.I18n.getText('gh.rapid.subnavigator.work.scrum.header.no.sprint')
    };

    test('itemList should only contain kanban item when in Kanban mode', function() {
        workSubnavigatorContextProvider._isKanban.returns(true);

        var itemList = workSubnavigatorContextProvider.itemList();

        equal(itemList.length, 1, 'itemList does not contain only 1 item');
        deepEqual(itemList[0], kanbanListItem, 'Only item in itemList is not kanbanListItem');
    });

    test('itemList should only contain noActiveSprint item when no active sprints', function() {
        workSubnavigatorContextProvider._isKanban.returns(false);
        workSubnavigatorContextProvider._getSprints.returns([]);

        var itemList = workSubnavigatorContextProvider.itemList();

        equal(itemList.length, 1, 'itemList does not contain only 1 item');
        deepEqual(itemList[0], noActiveSprintListItem, 'Only item in itemList is not noActiveSprintListItem');
    });

    test('selectedItem should be kanbanListItem.id when in Kanban mode', function() {
        workSubnavigatorContextProvider._isKanban.returns(true);

        var selectedItem = workSubnavigatorContextProvider.selectedItem();

        equal(selectedItem, kanbanListItem.id, 'selectedItem is not kanbanListItem.id');
    });

    test('selectedItem should be noActiveSprintListItem.id when no active sprints', function() {
        workSubnavigatorContextProvider._isKanban.returns(false);
        workSubnavigatorContextProvider._getSprints.returns([]);

        var selectedItem = workSubnavigatorContextProvider.selectedItem();

        equal(selectedItem, noActiveSprintListItem.id, 'selectedItem is not noActiveSprintListItem.id');
    });

    test('should return correct sprint goal when there is only 1 active sprint', function() {
        mockWorkControls.hasParallelSprints = false;
        mockWorkControls.activeSprintFilterId = undefined; // filter id does not matter when parallel active sprints are not enabled
        var sprintGoal = workSubnavigatorContextProvider.getSprintGoal();
        equal(sprintGoal, mockWorkControls.sprints[0].goal, 'correct goal is returned for specific active sprint');
    });

    test('should return correct sprint goal when a specific sprint is selected from filter', function() {
        mockWorkControls.hasParallelSprints = true;
        mockWorkControls.activeSprintFilterId = 1; // This means a specific sprint with id 1 is selected
        var sprintGoal = workSubnavigatorContextProvider.getSprintGoal();
        equal(sprintGoal, mockWorkControls.sprints[0].goal, 'correct goal is returned for specific active sprint');
    });

    test('should not return a sprint goal when "all sprints" filter is active', function() {
        mockWorkControls.hasParallelSprints = true;
        mockWorkControls.activeSprintFilterId = undefined; // This means "All sprints" is selected
        var sprintGoal = workSubnavigatorContextProvider.getSprintGoal();
        equal(sprintGoal, '', 'no goal is returned when all sprints are selected');
    });
});
