define('jira-agile/ui-utils', ["jquery"], function ($) {
    const UI = {};

    UI.isDisabled = function(elem) {
        var el = $(elem);
        return el.hasClass("disabled") || (el.attr("aria-disabled") == "true");
    };

    // included to allow code that uses it to be more readable
    UI.isEnabled = function(elem) {
        return !UI.isDisabled(elem);
    };

    UI.isVisibleY = function(pos) {
        var windowHeight = $(window).height();
        var scrollPosition = $(document).scrollTop();
        return pos > scrollPosition && pos < windowHeight + scrollPosition;
    };

    UI.isVisibleX = function(pos) {
        var windowWidth = $(window).width();
        var scrollPosition = $(document).scrollLeft();
        return pos > scrollPosition && pos < windowWidth + scrollPosition;
    };

    UI.ariaEnable = function(elem) {
        $(elem).removeAttr("aria-disabled");
    };

    UI.ariaDisable = function(elem) {
        $(elem).attr("aria-disabled", "true");
    };

    return UI;
});

AJS.namespace('GH.Util.UI', null, require('jira-agile/ui-utils'));
