QUnit.GhFixtures = QUnit.GhFixtures || {};

QUnit.GhFixtures.loadFixtures = function () {
    var container = document.createElement("div");
    container.setAttribute("id", "qunit-html-fixtures");
    document.body.appendChild(container);
};

QUnit.GhFixtures.getFixturesContainer = function () {
    return document.getElementById("qunit-html-fixtures");
};

QUnit.GhFixtures.removeFixtures = function () {
    var container = document.getElementById("qunit-html-fixtures");
    container.parentNode.removeChild(container);
};

QUnit.GhFixtures.addFixture = function (htmlString) {
    var container = document.getElementById("qunit-html-fixtures");
    var elem = document.createElement("div");
    elem.innerHTML = htmlString;
    container.appendChild(elem);
};

QUnit.testStart(QUnit.GhFixtures.loadFixtures);

QUnit.testDone(function () {
    QUnit.GhFixtures.removeFixtures();
});