/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzerResult;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzingStatistics;
import java.util.Objects;

@EventName(value="jira.indexanalyzer.analysis.completed")
public class AnalysisCompletedEvent {
    private final int okCount;
    private final int dbOrphansCount;
    private final int indexOrphansCount;
    private final float indexHealth;
    private final int outdatedCount;
    private final long indexIssueGatherTime;
    private final long dbStreamingAndAnalyzingTime;

    public AnalysisCompletedEvent(AnalyzerResult analyzerResult, AnalyzingStatistics analyzingStatistics) {
        Objects.requireNonNull(analyzerResult);
        Objects.requireNonNull(analyzingStatistics);
        this.okCount = analyzerResult.getOkCount();
        this.dbOrphansCount = analyzerResult.getDbOrphansCount();
        this.indexOrphansCount = analyzerResult.getIndexOrphansCount();
        this.indexHealth = analyzerResult.getIndexHealth();
        this.outdatedCount = analyzerResult.getOutdatedIssueCount();
        this.dbStreamingAndAnalyzingTime = analyzingStatistics.getDbStreamingAndAnalyzingTime();
        this.indexIssueGatherTime = analyzingStatistics.getIndexIssueGatherTime();
    }

    public int getOkCount() {
        return this.okCount;
    }

    public int getDbOrphansCount() {
        return this.dbOrphansCount;
    }

    public int getIndexOrphansCount() {
        return this.indexOrphansCount;
    }

    public float getIndexHealth() {
        return this.indexHealth;
    }

    public int getOutdatedCount() {
        return this.outdatedCount;
    }

    public long getIndexIssueGatherTime() {
        return this.indexIssueGatherTime;
    }

    public long getDbStreamingAndAnalyzingTime() {
        return this.dbStreamingAndAnalyzingTime;
    }
}

