/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.plugins.indexanalyzer.model.IssueData;
import com.atlassian.jira.util.collect.CloseableIterator;
import java.util.Date;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class DBActiveIssuesIterator
implements CloseableIterator<IssueData> {
    private static final String ID_COLUMN_NAME = "id";
    private static final String PROJECT_COLUMN_NAME = "project";
    private static final String UPDATED_COLUMN_NAME = "updated";
    public static String[] REQUIRED_FIELDS = new String[]{"id", "project", "updated"};
    private final OfBizListIterator ofBizListIterator;
    private final Set<Long> archivedProjectIds;
    private IssueData nextElement = null;

    public DBActiveIssuesIterator(OfBizListIterator ofBizListIterator, Set<Long> archivedProjectIds) {
        this.ofBizListIterator = ofBizListIterator;
        this.archivedProjectIds = archivedProjectIds;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.ofBizListIterator.close();
    }

    public boolean hasNext() {
        GenericValue genericValue = this.ofBizListIterator.next();
        this.nextElement = null;
        while (this.nextElement == null && genericValue != null) {
            Long projectId = genericValue.getLong(PROJECT_COLUMN_NAME);
            if (this.archivedProjectIds.contains(projectId)) {
                genericValue = this.ofBizListIterator.next();
                continue;
            }
            this.nextElement = new IssueData(genericValue.getLong(ID_COLUMN_NAME), this.truncateToSeconds(genericValue.getTimestamp(UPDATED_COLUMN_NAME)));
            genericValue = null;
        }
        return this.nextElement != null;
    }

    private Date truncateToSeconds(Date date) {
        return new Date(date.getTime() / 1000L * 1000L);
    }

    public IssueData next() {
        return this.nextElement;
    }
}

