/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.indexanalyzer.api.DataAnalyzer;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerBusyException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerGeneralException;
import com.atlassian.jira.plugins.indexanalyzer.events.AnalysisCompletedEvent;
import com.atlassian.jira.plugins.indexanalyzer.impl.DatabaseIssuesDataProvider;
import com.atlassian.jira.plugins.indexanalyzer.impl.IndexAnalyzerLockingExecutor;
import com.atlassian.jira.plugins.indexanalyzer.impl.IndexIssuesDataProvider;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzerResult;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzingStatistics;
import com.atlassian.jira.plugins.indexanalyzer.model.IssueData;
import com.atlassian.jira.plugins.indexanalyzer.model.OutdatedIssueData;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.jira.util.collect.CloseableIterator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultDataAnalyzer
implements DataAnalyzer {
    private static final AnalyzingStatistics analyzingStatistics = new AnalyzingStatistics();
    private final EventPublisher eventPublisher;
    private final IndexAnalyzerLockingExecutor lockingExecutor;
    private final IndexIssuesDataProvider indexDataProvider;
    private final DatabaseIssuesDataProvider databaseIssuesDataProvider;

    @Autowired
    public DefaultDataAnalyzer(@ComponentImport EventPublisher eventPublisher, IndexAnalyzerLockingExecutor lockingExecutor, IndexIssuesDataProvider indexIssuesDataProvider, DatabaseIssuesDataProvider databaseIssuesDataProvider) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.lockingExecutor = lockingExecutor;
        this.indexDataProvider = Objects.requireNonNull(indexIssuesDataProvider);
        this.databaseIssuesDataProvider = Objects.requireNonNull(databaseIssuesDataProvider);
    }

    @Override
    public AnalyzingStatistics getAnalyzingStatistics() {
        return analyzingStatistics;
    }

    @Override
    public AnalyzerResult analyze(int maxResults) throws IndexAnalyzerGeneralException, IndexAnalyzerBusyException {
        return this.lockingExecutor.execute(() -> {
            StopWatch stopWatch = new StopWatch();
            Map<Long, Date> indexIssuesData = this.indexDataProvider.getIssuesData();
            long indexIssuesRetrievalTime = stopWatch.getIntervalTime();
            AnalyzerResult analyzerResult = this.performAnalysis(indexIssuesData, maxResults);
            long analysisTime = stopWatch.getIntervalTime();
            analyzingStatistics.setStatistics(indexIssuesRetrievalTime, analysisTime);
            this.eventPublisher.publish((Object)new AnalysisCompletedEvent(analyzerResult, analyzingStatistics));
            return analyzerResult;
        });
    }

    private AnalyzerResult performAnalysis(Map<Long, Date> indexIssuesData, int maxResults) {
        int okCount = 0;
        int outdatedCount = 0;
        int databaseOrphansCount = 0;
        int databaseCount = 0;
        ArrayList<IssueData> databaseOrphans = new ArrayList<IssueData>();
        ArrayList<OutdatedIssueData> outdatedIssueData = new ArrayList<OutdatedIssueData>();
        try (CloseableIterator<IssueData> databaseIssuesIterator = this.databaseIssuesDataProvider.getIssuesDataIterator();){
            while (databaseIssuesIterator.hasNext()) {
                IssueData dbIssueData = (IssueData)databaseIssuesIterator.next();
                Long issueId = dbIssueData.getIssueId();
                Date indexLastUpdated = indexIssuesData.get(issueId);
                ++databaseCount;
                if (indexLastUpdated == null) {
                    DefaultDataAnalyzer.addToList(databaseOrphans, dbIssueData, maxResults);
                    ++databaseOrphansCount;
                    continue;
                }
                if (!indexLastUpdated.equals(dbIssueData.getLastUpdated())) {
                    DefaultDataAnalyzer.addToList(outdatedIssueData, new OutdatedIssueData(issueId, dbIssueData.getLastUpdated(), indexLastUpdated), maxResults);
                    ++outdatedCount;
                } else {
                    ++okCount;
                }
                indexIssuesData.remove(issueId);
            }
        }
        int indexOrphansCount = indexIssuesData.size();
        List<IssueData> indexOrphans = indexIssuesData.entrySet().stream().limit(maxResults).map(entry -> new IssueData((Long)entry.getKey(), (Date)entry.getValue())).collect(Collectors.toList());
        return new AnalyzerResult(indexOrphans, databaseOrphans, outdatedIssueData, okCount, databaseCount, outdatedCount, indexOrphansCount, databaseOrphansCount);
    }

    private static <T> void addToList(List<T> list, T item, int maxResults) {
        if (list.size() < maxResults) {
            list.add(item);
        }
    }
}

