/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerBusyException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerGeneralException;
import com.atlassian.jira.plugins.indexanalyzer.impl.IndexAnalyzerRunnable;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.stereotype.Component;

@Component
class IndexAnalyzerLockingExecutor {
    private final ReentrantLock lock;

    public IndexAnalyzerLockingExecutor() {
        this(new ReentrantLock());
    }

    @VisibleForTesting
    IndexAnalyzerLockingExecutor(ReentrantLock lock) {
        this.lock = lock;
    }

    public <V> V execute(IndexAnalyzerRunnable<V> runnable) throws IndexAnalyzerGeneralException, IndexAnalyzerBusyException {
        if (this.lock.tryLock()) {
            try {
                V v = runnable.run();
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new IndexAnalyzerBusyException();
    }

    public boolean isBusy() {
        return this.lock.isLocked();
    }
}

