/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerGeneralException;
import com.atlassian.jira.plugins.indexanalyzer.impl.IssueDataCollector;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Collector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexIssuesDataProvider {
    private final SearchProvider searchProvider;

    @Autowired
    public IndexIssuesDataProvider(@ComponentImport SearchProvider searchProvider) {
        this.searchProvider = Objects.requireNonNull(searchProvider);
    }

    public Map<Long, Date> getIssuesData() throws IndexAnalyzerGeneralException {
        IssueDataCollector issueDataCollector = new IssueDataCollector();
        try {
            this.searchProvider.search(SearchQuery.create((Query)JqlQueryBuilder.newBuilder().buildQuery(), null).overrideSecurity(true), (Collector)issueDataCollector);
        }
        catch (SearchException e) {
            throw new IndexAnalyzerGeneralException("Couldn't read issues from index", (Exception)((Object)e));
        }
        return issueDataCollector.getIssueData();
    }
}

