/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.rest;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.indexanalyzer.api.DataAnalyzer;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerBusyException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexAnalyzerGeneralException;
import com.atlassian.jira.plugins.indexanalyzer.api.IndexHealer;
import com.atlassian.jira.plugins.indexanalyzer.model.AnalyzerResult;
import com.atlassian.jira.plugins.indexanalyzer.model.HealResult;
import com.atlassian.jira.plugins.indexanalyzer.model.HealerResult;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IndexAnalyzerResource {
    @VisibleForTesting
    static final int MAX_ELEMENTS_ALLOWED = 1000;
    private final DataAnalyzer dataAnalyzer;
    private final IndexHealer indexHealer;
    private final JiraAuthenticationContext authenticationContext;
    private final GlobalPermissionManager globalPermissionManager;

    public IndexAnalyzerResource(DataAnalyzer dataAnalyzer, IndexHealer indexHealer, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager) {
        this.dataAnalyzer = Objects.requireNonNull(dataAnalyzer);
        this.indexHealer = Objects.requireNonNull(indexHealer);
        this.authenticationContext = authenticationContext;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Path(value="state")
    @GET
    public Response getState(@DefaultValue(value="100") @QueryParam(value="maxResults") int maxResults) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            AnalyzerResult analyze = this.dataAnalyzer.analyze(maxResults);
            return Response.ok((Object)analyze).build();
        }
        catch (IndexAnalyzerGeneralException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (IndexAnalyzerBusyException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="heal")
    @POST
    public Response healIndex(@DefaultValue(value="100") @QueryParam(value="maxResults") int maxResults) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (maxResults > 1000) {
            return Response.status((int)422).entity((Object)"No more than 1000 issues can be healed at once").build();
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            AnalyzerResult analyzeBeforeResult = this.dataAnalyzer.analyze(maxResults);
            long analyzeBeforeTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            stopwatch.reset().start();
            HealerResult healResult = this.indexHealer.heal(analyzeBeforeResult);
            long healTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            stopwatch.reset().start();
            AnalyzerResult analyzeAfterResult = this.dataAnalyzer.analyze(maxResults);
            long analyzeAfterTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            return Response.ok((Object)new HealResult(analyzeBeforeResult, analyzeBeforeTime, healResult, healTime, analyzeAfterResult, analyzeAfterTime)).build();
        }
        catch (IndexAnalyzerGeneralException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (IndexAnalyzerBusyException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="busy")
    @GET
    public Response isBusy() {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.indexHealer.isBusy()).build();
    }

    @Path(value="statistics")
    @GET
    public Response getStatistics() {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authenticationContext.getLoggedInUser())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok((Object)this.dataAnalyzer.getAnalyzingStatistics()).build();
    }
}

