/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.dump.TestInformationKit;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.apache.commons.lang.StringUtils;

public abstract class BackdoorControl<T extends BackdoorControl<T>>
extends RestApiClient<T> {
    public static final String DEFAULT_REST_PATH = "testkit-test";
    public static final String API_REST_PATH = "api";
    public static final String API_REST_VERSION = "2";
    protected final String rootPath;
    protected final FuncTestLogger logger;

    public BackdoorControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.rootPath = environmentData.getBaseUrl().toExternalForm();
        this.logger = new FuncTestLoggerImpl(2);
    }

    protected final String get(WebResource webResource) {
        return (String)webResource.get(String.class);
    }

    protected final WebResource createResourceForPath(String restModulePath) {
        return this.createResourceForPath(restModulePath, "1.0");
    }

    protected final WebResource createResourceForPath(String restModulePath, String restModuleVersion) {
        WebResource resource = this.resourceRoot(this.rootPath).path("rest").path(restModulePath).path(restModuleVersion);
        resource.addFilter((ClientFilter)new BackdoorLoggingFilter());
        resource.addFilter((ClientFilter)new JsonMediaTypeFilter());
        return resource;
    }

    @Override
    protected WebResource createResource() {
        return this.createResourceForPath(this.getRestModulePath());
    }

    protected String getRestModulePath() {
        return DEFAULT_REST_PATH;
    }

    protected static class JsonMediaTypeFilter
    extends ClientFilter {
        protected JsonMediaTypeFilter() {
        }

        public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
            if (request.getEntity() != null && !request.getHeaders().containsKey((Object)"Content-Type")) {
                request.getHeaders().putSingle((Object)"Content-Type", (Object)"application/json");
            }
            return this.getNext().handle(request);
        }
    }

    protected class BackdoorLoggingFilter
    extends ClientFilter {
        protected BackdoorLoggingFilter() {
        }

        public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
            FuncTestTimer timer = TestInformationKit.pullTimer("Backdoor Shenanigans");
            ClientResponse response = this.getNext().handle(request);
            this.logRequest(request, timer.end());
            return response;
        }

        private void logRequest(ClientRequest request, long howLong) {
            String relativePath = StringUtils.removeStart((String)request.getURI().getPath(), (String)BackdoorControl.this.createResource().getURI().getPath());
            BackdoorControl.this.logger.log(String.format("Backdoor %-6s in %5dms  %s", request.getMethod(), howLong, relativePath));
        }
    }
}

