/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class IssueTypeControl
extends BackdoorControl<IssueTypeControl> {
    private static final GenericType<List<IssueType>> LIST_GENERIC_TYPE = new GenericType<List<IssueType>>(){};

    public IssueTypeControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public IssueType createIssueType(String name) {
        return this.createIssueType(name, "/images/icons/genericissue.gif");
    }

    public IssueType createIssueType(String name, String iconURL) {
        IssueType issueType = new IssueType();
        issueType.setName(name);
        issueType.setIconUrl(iconURL);
        issueType.setSubtask(false);
        return (IssueType)this.createIssueTypeResource().post(IssueType.class, (Object)issueType);
    }

    public List<IssueType> getIssueTypes() {
        return (List)this.createIssueTypeResource().get(LIST_GENERIC_TYPE);
    }

    public void deleteIssueType(long id) {
        this.createIssueTypeResource().path(String.valueOf(id)).delete();
    }

    private WebResource createIssueTypeResource() {
        return this.createResource().path("issueType");
    }

    public static class IssueType {
        private String id;
        private String description;
        private String iconUrl;
        private String name;
        private boolean subtask;

        public IssueType() {
        }

        public IssueType(String id, String name, String description, String iconUrl, boolean subtask) {
            this.id = id;
            this.description = description;
            this.iconUrl = iconUrl;
            this.name = name;
            this.subtask = subtask;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSubtask() {
            return this.subtask;
        }

        public void setSubtask(boolean subtask) {
            this.subtask = subtask;
        }
    }
}

