/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.dump;

import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.dump.FuncTestTimerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestInformationKit {
    private static Map<String, Map<String, TestCaseCounter>> testCaseCounters = new HashMap<String, Map<String, TestCaseCounter>>();
    private static String currentTestName = null;

    public static void recordCounter(String counterName, long value) {
        if (currentTestName != null) {
            TestCaseCounter testCaseCounter;
            Map<String, TestCaseCounter> counterMap = testCaseCounters.get(currentTestName);
            if (counterMap == null) {
                counterMap = new HashMap<String, TestCaseCounter>();
                testCaseCounters.put(currentTestName, counterMap);
            }
            if ((testCaseCounter = counterMap.get(counterName)) == null) {
                testCaseCounter = new TestCaseCounter(counterName);
                counterMap.put(counterName, testCaseCounter);
            }
            testCaseCounter.update(value);
        }
    }

    public static List<TestCaseCounter> getCountersForTest(String testName) {
        ArrayList<TestCaseCounter> counters = new ArrayList<TestCaseCounter>();
        Map<String, TestCaseCounter> mapOfCounters = testCaseCounters.get(testName);
        if (mapOfCounters != null) {
            for (String counterName : mapOfCounters.keySet()) {
                counters.add(mapOfCounters.get(counterName));
            }
        }
        return counters;
    }

    public static FuncTestTimer pullTimer(String name) {
        return new FuncTestTimerImpl(name);
    }

    public static class TestCaseCounter {
        private final String name;
        private double value;

        private TestCaseCounter(String name) {
            this.name = name;
            this.value = 0.0;
        }

        public double update(double value) {
            this.value += value;
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }
    }
}

