/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.restclient.UserJson;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonRawValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonIgnoreProperties(ignoreUnknown=true)
public class Comment {
    public String self;
    public String id;
    public String created;
    public String updated;
    public String body;
    public String renderedBody;
    public UserJson author;
    public UserJson updateAuthor;
    public Visibility visibility;
    public List<CommentProperty> properties;

    public Comment() {
    }

    public Comment(String body, String roleLevel) {
        this.body = body;
        this.visibility = new Visibility("ROLE", roleLevel);
    }

    public void setProperties(List<Map<String, Object>> properties) {
        this.properties = Lists.transform(properties, (Function)new Function<Map<String, Object>, CommentProperty>(){

            public CommentProperty apply(Map<String, Object> commentProperty) {
                String key = (String)commentProperty.get("key");
                return new CommentProperty(key, new JSONObject((Map)commentProperty.get("value")).toString());
            }
        });
    }

    public static class CommentProperty {
        public String key;
        @JsonRawValue
        public String value;

        public CommentProperty() {
        }

        public CommentProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

