/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;

public class FilterClient
extends RestApiClient<FilterClient> {
    public FilterClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Filter get(String filterId, Filter.Expand ... expand) throws UniformInterfaceException {
        return (Filter)this.filterWithId(filterId, expand).get(Filter.class);
    }

    public List<Filter> getFavouriteFilters(Filter.Expand ... expand) {
        return (List)this.addExpands(this.createResource().path("filter").path("favourite"), expand).get(Filter.FILTER_TYPE);
    }

    public Response getResponse(final String filterId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterWithId(filterId, new Filter.Expand[0]).get(ClientResponse.class);
            }
        });
    }

    private WebResource filterResource() {
        return this.createResource().path("filter");
    }

    private WebResource addExpands(WebResource resource, Filter.Expand ... expand) {
        EnumSet expands = FilterClient.setOf(Filter.Expand.class, (Enum[])expand);
        if (expands.isEmpty()) {
            return resource;
        }
        return resource.queryParam("expand", FilterClient.percentEncode(StringUtils.join((Collection)expands, (String)",")));
    }

    protected WebResource filterWithId(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.createResource().path("filter").path(filterId), expand);
    }

    public Response<Filter> postFilterResponse(final Filter filter, final Filter.Expand ... expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterResourceForPost(expand).post(ClientResponse.class, (Object)filter);
            }
        }, Filter.class);
    }

    public Response<Filter> putFilterResponse(final Filter filter, final Filter.Expand ... expand) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)FilterClient.this.filterResourceForPut(filter.id, expand).put(ClientResponse.class, (Object)filter);
            }
        }, Filter.class);
    }

    private WebResource.Builder filterResourceForPut(String filterId, Filter.Expand ... expand) {
        return this.addExpands(this.filterResource().path(filterId), expand).type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource.Builder filterResourceForPost(Filter.Expand ... expand) {
        return this.addExpands(this.filterResource(), expand).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public Map<String, String> getDefaultShareScope() {
        return (Map)this.createResource().path("filter").path("defaultShareScope").get((GenericType)new GenericType<Map<String, String>>(){});
    }

    public Map<String, String> setDefaultShareScope(Map<String, String> scope) {
        return (Map)this.createResource().path("filter").path("defaultShareScope").type(MediaType.APPLICATION_JSON_TYPE).put((GenericType)new GenericType<Map<String, String>>(){}, scope);
    }
}

