/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.restclient.Comment;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonProperty;

public class LinkRequest {
    public static final String FIELD_NAME = "issuelinks";
    @JsonProperty
    private ResourceRef type;
    @JsonProperty
    private ResourceRef inwardIssue;
    @JsonProperty
    private ResourceRef outwardIssue;
    @JsonProperty
    private Comment comment;

    public LinkRequest() {
    }

    public LinkRequest(ResourceRef type, ResourceRef inwardIssue, ResourceRef outwardIssue, Comment comment) {
        this.comment = comment;
        this.type = type;
        this.inwardIssue = inwardIssue;
        this.outwardIssue = outwardIssue;
    }

    public ResourceRef type() {
        return this.type;
    }

    public LinkRequest type(ResourceRef linkType) {
        return new LinkRequest(linkType, this.inwardIssue, this.outwardIssue, this.comment);
    }

    public ResourceRef inwardIssue() {
        return this.inwardIssue;
    }

    public LinkRequest inwardIssue(ResourceRef inwardIssue) {
        return new LinkRequest(this.type, inwardIssue, this.outwardIssue, this.comment);
    }

    public ResourceRef outwardIssue() {
        return this.outwardIssue;
    }

    public LinkRequest outwardIssue(ResourceRef outwardIssue) {
        return new LinkRequest(this.type, this.inwardIssue, outwardIssue, this.comment);
    }

    public Comment comment() {
        return this.comment;
    }

    public LinkRequest comment(Comment comment) {
        return new LinkRequest(this.type, this.inwardIssue, this.outwardIssue, comment);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

