/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class WorklogClient
extends RestApiClient<WorklogClient> {
    public WorklogClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public WorklogWithPaginationBean getAll(String issueKey) {
        return (WorklogWithPaginationBean)this.createResource().path("issue").path(issueKey).path("worklog").get(WorklogWithPaginationBean.class);
    }

    public Worklog get(String issueKey, String worklogID) throws UniformInterfaceException {
        return (Worklog)this.worklogWithID(issueKey, worklogID).get(Worklog.class);
    }

    public Response getResponse(final String issueKey, final String worklogID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WorklogClient.this.worklogWithID(issueKey, worklogID).get(ClientResponse.class);
            }
        });
    }

    protected WebResource worklogWithID(String issueKey, String worklogID) {
        return this.createResource().path("issue").path(issueKey).path("worklog").path(worklogID);
    }

    public Response<Worklog> put(final String issueKey, final Worklog worklog) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)worklog);
            }
        }, Worklog.class);
    }

    public Response<Worklog> put(final String issueKey, final Worklog worklog, final Map<String, String> queryParams) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource path = WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id);
                for (Map.Entry entry : queryParams.entrySet()) {
                    path = path.queryParam((String)entry.getKey(), (String)entry.getValue());
                }
                return (ClientResponse)path.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)worklog);
            }
        }, Worklog.class);
    }

    public Response<Worklog> post(final String issueKey, final Worklog worklog) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)worklog);
            }
        }, Worklog.class);
    }

    public Response<Worklog> post(final String issueKey, final Worklog worklog, final Map<String, String> queryParams) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource path = WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog");
                for (Map.Entry entry : queryParams.entrySet()) {
                    path = path.queryParam((String)entry.getKey(), (String)entry.getValue());
                }
                return (ClientResponse)path.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)worklog);
            }
        }, Worklog.class);
    }

    public Response delete(final String issueKey, final Worklog worklog) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        });
    }

    public Response delete(final String issueKey, final Worklog worklog, final Map<String, String> queryParams) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource path = WorklogClient.this.createResource().path("issue").path(issueKey).path("worklog").path(worklog.id);
                for (Map.Entry entry : queryParams.entrySet()) {
                    path = path.queryParam((String)entry.getKey(), (String)entry.getValue());
                }
                return (ClientResponse)path.type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        });
    }
}

