/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.rules;

import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.rules.AnnotatedDescription;
import com.atlassian.jira.testkit.client.rules.EnableWebSudo;
import com.google.common.collect.ImmutableList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WebSudoRule
implements TestRule {
    private final ImmutableList<Backdoor> jiras;

    public <T extends Backdoor> WebSudoRule(T ... jiras) {
        this.jiras = ImmutableList.copyOf((Object[])jiras);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (WebSudoRule.this.shouldEnable(description)) {
                    for (Backdoor jira : WebSudoRule.this.jiras) {
                        jira.websudo().enable();
                    }
                } else {
                    for (Backdoor jira : WebSudoRule.this.jiras) {
                        jira.websudo().disable();
                    }
                }
                base.evaluate();
            }
        };
    }

    private boolean shouldEnable(Description description) {
        return new AnnotatedDescription(description).hasAnnotation(EnableWebSudo.class);
    }
}

