/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.util;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractEnvironmentData
implements JIRAEnvironmentData {
    private final String releaseInfo;
    private final Properties properties;

    protected AbstractEnvironmentData(Properties properties) {
        this.properties = properties;
        this.releaseInfo = properties.getProperty("jira.release.info");
    }

    @Override
    public boolean isBundledPluginsOnly() {
        return this.getEdition().toLowerCase().indexOf("bundledplugins") != -1;
    }

    @Override
    public boolean isTpmLdapTests() {
        return this.getEdition().equalsIgnoreCase("tpm_ldap");
    }

    @Override
    public boolean isBlame() {
        return this.getEdition().equalsIgnoreCase("blame");
    }

    @Override
    public boolean isAllTests() {
        return this.getEdition().toLowerCase().indexOf("all") != -1;
    }

    protected abstract String getEdition();

    @Override
    public String getReleaseInfo() {
        return this.releaseInfo;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    protected String getEnvironmentProperty(String key, String defaultValue) {
        String property = System.getProperty(key);
        if (StringUtils.isEmpty((String)property)) {
            property = this.properties != null ? this.properties.getProperty(key, defaultValue) : defaultValue;
        }
        return property;
    }

    @Override
    public boolean isSingleNamedTest() {
        return this.getSingleTestClassName() != null;
    }

    private String getSingleTestClassName() {
        String singleTestclass = this.getEnvironmentProperty("jira.functest.single.testclass", "");
        return StringUtils.isEmpty((String)singleTestclass) ? null : singleTestclass;
    }

    @Override
    public String getTenant() {
        return this.getEnvironmentProperty("jira.tenant", null);
    }

    @Override
    public boolean shouldCreateDummyTenant() {
        return Boolean.parseBoolean(this.getEnvironmentProperty("jira.create.dummy.tenant", "false"));
    }

    @Override
    public Class<? extends TestCase> getSingleTestClass() {
        try {
            return Class.forName(this.getSingleTestClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not construct single testclass" + this.getSingleTestClassName(), e);
        }
    }
}

