/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;

public class ProjectUtils {
    public static boolean shouldDeployTestJar(MavenContext context) {
        File testResources = FileUtils.file(context.getProject().getBasedir(), "src", "test", "resources");
        File pluginXml = new File(testResources, "atlassian-plugin.xml");
        return pluginXml.exists();
    }

    public static <T> T firstNotNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        throw new NullPointerException("All values are null");
    }

    public static File createDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Failed to create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    @Nullable
    public static Artifact getReactorArtifact(MavenContext context, String groupId, String artifactId) {
        return context.getProject().getArtifacts().stream().filter(a -> a.getGroupId().equals(groupId)).filter(a -> a.getArtifactId().equals(artifactId)).findFirst().orElse(null);
    }
}

