/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.plugins.osgi.test.Application;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.RunWith;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class TestClassVisitor
extends ClassVisitor {
    private boolean isWiredTestClass = false;
    private boolean inITPackage = false;
    private String applicationFilter = "";

    public TestClassVisitor() {
        super(327680);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String normalClassName = TestClassVisitor.normalize(name);
        if (normalClassName.startsWith("it.")) {
            this.inITPackage = true;
        }
    }

    public void visitEnd() {
    }

    public AnnotationVisitor visitAnnotation(String annoName, boolean isVisible) {
        String normalName = TestClassVisitor.normalize(annoName);
        if (RunWith.class.getName().equals(normalName)) {
            return new RunWithAnnotationVisitor();
        }
        if (Application.class.getName().equals(normalName)) {
            return new ApplicationAnnotationVisitor();
        }
        return null;
    }

    public boolean isWiredTest() {
        return this.isWiredTestClass && this.inITPackage;
    }

    static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }

    public String getApplicationFilter() {
        return this.applicationFilter;
    }

    private class ApplicationAnnotationVisitor
    extends AnnotationVisitor {
        public ApplicationAnnotationVisitor() {
            super(327680);
        }

        public void visit(String name, Object value) {
            String app;
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)(app = (String)value))) {
                TestClassVisitor.this.applicationFilter = app;
            }
        }
    }

    private class RunWithAnnotationVisitor
    extends AnnotationVisitor {
        public RunWithAnnotationVisitor() {
            super(327680);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                Type type = (Type)value;
                if (AtlassianPluginsTestRunner.class.getName().equals(TestClassVisitor.normalize(type.getInternalName()))) {
                    TestClassVisitor.this.isWiredTestClass = true;
                }
            }
        }
    }
}

