/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.interceptors.connection;

import java.lang.reflect.InvocationTargetException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionTracker;

public class ConnectionPoolInfoSynthesizer {
    public static ConnectionPoolInfo synthesizeConnectionPoolInfo(DataSource ds) {
        if (ds instanceof BasicDataSource) {
            return ConnectionPoolInfoSynthesizer.copyBasicDataSource((BasicDataSource)ds);
        }
        if ("org.apache.tomcat.dbcp.dbcp.BasicDataSource".equals(ds.getClass().getName())) {
            return ConnectionPoolInfoSynthesizer.reflectDataSource(ds);
        }
        return ConnectionTracker.UNKNOWN_CONNECTION_POOL_INFO;
    }

    private static ConnectionPoolInfo copyBasicDataSource(BasicDataSource bds) {
        return new ConnectionPoolInfo(bds.getMaxActive(), bds.getMinIdle(), bds.getMaxWait(), -1L, -1L, -1L, -1L, bds.getValidationQuery(), bds.getMinEvictableIdleTimeMillis(), bds.getTimeBetweenEvictionRunsMillis());
    }

    private static ConnectionPoolInfo reflectDataSource(DataSource ds) {
        return new ConnectionPoolInfo(ConnectionPoolInfoSynthesizer.getInt(ds, "getMaxActive"), ConnectionPoolInfoSynthesizer.getInt(ds, "getMinIdle"), ConnectionPoolInfoSynthesizer.getLong(ds, "getMaxWait"), -1L, -1L, -1L, -1L, ConnectionPoolInfoSynthesizer.getStr(ds, "getValidationQuery"), ConnectionPoolInfoSynthesizer.getLong(ds, "getMinEvictableIdleTimeMillis"), ConnectionPoolInfoSynthesizer.getLong(ds, "getTimeBetweenEvictionRunsMillis"));
    }

    private static Integer getInt(DataSource ds, String methodName) {
        try {
            Object val = ds.getClass().getMethod(methodName, new Class[0]).invoke((Object)ds, new Object[0]);
            if (val instanceof Long) {
                return ((Long)val).intValue();
            }
            return (Integer)val;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Long getLong(DataSource ds, String methodName) {
        try {
            Object val = ds.getClass().getMethod(methodName, new Class[0]).invoke((Object)ds, new Object[0]);
            if (val instanceof Integer) {
                return ((Integer)val).longValue();
            }
            return (Long)val;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String getStr(DataSource ds, String methodName) {
        try {
            return (String)ds.getClass().getMethod(methodName, new Class[0]).invoke((Object)ds, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

