/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.aui;

import com.atlassian.functest.junit.SpringAwareJUnit4ClassRunner;
import com.atlassian.refapp.ctk.AbstractRestTest;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SpringAwareJUnit4ClassRunner.class)
public class AuiResourcesPresentTest
extends AbstractRestTest {
    private ApplicationProperties appProp;

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.appProp = Objects.requireNonNull(applicationProperties);
    }

    private List<String> fetchAuiHeaderLines() throws Exception {
        URI uri = UriBuilder.fromUri((String)this.appProp.getBaseUrl()).path("plugins/servlet/resource-using-servlet").build(new Object[0]);
        String header = this.get(uri);
        if (StringUtils.isNotEmpty((String)header)) {
            return ImmutableList.copyOf((Object[])header.split("\\r?\\n"));
        }
        return Collections.emptyList();
    }

    private static void assertContainsLineMatchingRegexp(Iterable<String> lines, String regex) {
        Pattern p = Pattern.compile(regex);
        for (String s : lines) {
            if (!p.matcher(s).matches()) continue;
            return;
        }
        Assert.fail((String)("Expected a collection including a line matching '" + regex + "' but was: " + lines));
    }

    @Test
    public void auiProvidesResources() throws Exception {
        Assert.assertFalse((boolean)this.fetchAuiHeaderLines().isEmpty());
    }

    @Test
    public void auiResourcesIncludeCss() throws Exception {
        AuiResourcesPresentTest.assertContainsLineMatchingRegexp(this.fetchAuiHeaderLines(), "<link[^>]+href=.*?\\.css.*");
    }

    @Test
    public void auiResourcesIncludeJavaScript() throws Exception {
        AuiResourcesPresentTest.assertContainsLineMatchingRegexp(this.fetchAuiHeaderLines(), "<script[^>]+src=.*?\\.js.*");
    }
}

