/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.message.MessageCollection;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class I18nResolverTest
extends SpringAwareTestCase {
    private I18nResolver resolver;

    public void setResolver(I18nResolver resolver) {
        this.resolver = resolver;
    }

    @Test
    public void testI18nResolverAvailable() {
        Assert.assertNotNull((String)"I18nResolver should be available to plugins", (Object)this.resolver);
    }

    @Test
    public void testCreateMessage() {
        Message msg = this.resolver.createMessage("key", new Serializable[]{"arg1"});
        Assert.assertTrue((String)"Should create valid message", (msg.getArguments().length == 1 && "key".equals(msg.getKey()) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateMessageCollection() {
        MessageCollection msgCollection = this.resolver.createMessageCollection();
        Assert.assertTrue((String)"Should be able to create message collection", (msgCollection != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"newly created messageCollection should be empty", (boolean)msgCollection.isEmpty());
        msgCollection.addMessage(this.resolver.createMessage("key1", new Serializable[]{"arg1"}));
        msgCollection.addMessage(this.resolver.createMessage("key2", new Serializable[]{"arg2"}));
        Assert.assertEquals((String)"only message we just added", (long)2L, (long)msgCollection.getMessages().size());
    }

    @Test
    public void testResolveNonExistingKey() {
        Assert.assertTrue((String)"Should return the input key if the text can't be resolved", (boolean)"some.key.that.doesnt.exist".equals(this.resolver.getText("some.key.that.doesnt.exist")));
    }

    @Test
    public void testGetAllTranslationsForPrefix() {
        Map translations = this.resolver.getAllTranslationsForPrefix("some.key.that.doesnt.exist", Locale.US);
        Assert.assertTrue((String)"Should return empty map of translations for unknown key", (boolean)translations.keySet().isEmpty());
    }

    @Test
    public void testGetRawTextReturnsKeyWhenUnknown() throws Exception {
        String unknownKey = "frkj46543^%$%^$T";
        Assert.assertEquals((Object)"frkj46543^%$%^$T", (Object)this.resolver.getText("frkj46543^%$%^$T"));
    }
}

