/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class PluginSchedulerTest
extends SpringAwareTestCase {
    private PluginScheduler scheduler;
    private SecureRandom random = new SecureRandom();

    public void setScheduler(PluginScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Test
    public void testPluginSchedulerAvailable() {
        Assert.assertNotNull((String)"PluginScheduler should be available to plugins", (Object)this.scheduler);
    }

    @Test
    public void testScheduledJobMustBeExecuted() throws InterruptedException {
        TestJob.calledCount.set(0);
        this.scheduler.scheduleJob("job" + this.random.nextInt(), TestJob.class, new HashMap(), new Date(), 10000000L);
        long startWait = System.currentTimeMillis();
        while (System.currentTimeMillis() - startWait < 65000L) {
            Thread.sleep(1000L);
            if (TestJob.calledCount.get() != 1) continue;
        }
        Assert.assertEquals((String)"Should be able to schedule job and have it called only once", (long)1L, (long)TestJob.calledCount.get());
    }

    @Test
    public void testUnscheduleExistingJobShouldNotThrowException() {
        String jobName = "job" + this.random.nextInt();
        this.scheduler.scheduleJob(jobName, TestJob.class, new HashMap(), new Date(), 10000000L);
        this.scheduler.unscheduleJob(jobName);
    }

    @Test
    public void testUnscheduleNonExistingJobShouldThrowIAE() {
        try {
            this.scheduler.unscheduleJob("job" + this.random.nextInt());
            Assert.fail((String)"Should throw IllegalArgumentException when unscheduling an unknown job");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class TestJob
    implements PluginJob {
        public static AtomicInteger calledCount = new AtomicInteger();

        public void execute(Map<String, Object> jobDataMap) {
            calledCount.incrementAndGet();
        }
    }
}

