/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TransactionalExecutorTest
extends SpringAwareTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TransactionalExecutorFactory factory;

    public void setFactory(TransactionalExecutorFactory factory) {
        this.factory = factory;
    }

    @Test
    public void factoryPresent() {
        MatcherAssert.assertThat((Object)this.factory, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void canCreateExecutor() {
        TransactionalExecutor executor = this.factory.createExecutor();
        MatcherAssert.assertThat((Object)executor, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void executeCallback() throws SQLException {
        final AtomicReference connectionRef = new AtomicReference();
        String executionResult = (String)this.factory.createExecutor().execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String execute(Connection connection) {
                MatcherAssert.assertThat((Object)connection, (Matcher)Matchers.notNullValue());
                connectionRef.set(connection);
                try {
                    connection.getMetaData().getSchemas();
                }
                catch (SQLException e) {
                    Assert.fail((String)("connection threw an SQLException:\n" + e));
                }
                return "success";
            }
        });
        MatcherAssert.assertThat((Object)executionResult, (Matcher)Is.is((Object)"success"));
        this.expectedException.expect(IllegalStateException.class);
        ((Connection)connectionRef.get()).getMetaData();
    }

    @Test
    public void retrieveSchema() {
        MatcherAssert.assertThat((Object)this.factory.createExecutor().getSchemaName(), (Matcher)Matchers.notNullValue());
    }
}

