/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.version;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.PlatformVersionSpecReader;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportVersionTest
extends SpringAwareTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportVersionTest.class);
    private static final Supplier<String> PLATFORM_VERSION_REF = new LazyReference<String>(){

        protected String create() {
            return PlatformVersionSpecReader.getPlatformVersion();
        }
    };
    private PackageAdmin packageAdmin;

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = Objects.requireNonNull(packageAdmin);
    }

    @Test
    public void checkPlatformPackageVersions() {
        String errors = PlatformVersionSpecReader.getExportVersionChecks().stream().map(this::execute).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n"));
        if (!errors.isEmpty()) {
            LOGGER.info("Failed to validate modules:\n{}", (Object)errors);
            Assert.fail((String)errors);
        }
    }

    private Optional<String> execute(PlatformVersionSpecReader.ExportVersionCheck exportCheck) {
        ExportedPackage export = this.packageAdmin.getExportedPackage(exportCheck.getPkg());
        if (exportCheck.isValid(export)) {
            return Optional.empty();
        }
        return Optional.of(ExportVersionTest.getError(exportCheck, export));
    }

    private static String getError(PlatformVersionSpecReader.ExportVersionCheck exportCheck, ExportedPackage export) {
        StringBuilder error = new StringBuilder().append("Atlassian Platform ").append((String)PLATFORM_VERSION_REF.get()).append(" must have ").append(exportCheck.getModuleName()).append("(").append(exportCheck.getPkg()).append(")  version:").append(exportCheck.getVersion());
        if (export == null) {
            error.append(" (no current version)");
        } else {
            error.append("  current version:").append(export.getVersion());
        }
        return error.toString();
    }
}

