/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.version;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.refapp.ctk.PlatformVersionSpecReader;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginVersionTest
extends SpringAwareTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginVersionTest.class);
    private static final Supplier<String> PLATFORM_VERSION_REF = new LazyReference<String>(){

        protected String create() {
            return PlatformVersionSpecReader.getPlatformVersion();
        }
    };
    private PluginAccessor pluginAccessor;

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @Test
    public void checkPlatformPluginVersions() {
        String errors = PlatformVersionSpecReader.getPluginVersionChecks().stream().map(this::execute).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n"));
        if (!errors.isEmpty()) {
            LOGGER.info("Failed to validate modules:\n{}", (Object)errors);
            Assert.fail((String)errors);
        }
    }

    private Optional<String> execute(PlatformVersionSpecReader.PluginVersionCheck pluginVersionCheck) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginVersionCheck.getPluginKey());
        if (pluginVersionCheck.isValid(plugin)) {
            return Optional.empty();
        }
        return Optional.of(PluginVersionTest.getError(pluginVersionCheck, plugin));
    }

    private static String getError(PlatformVersionSpecReader.PluginVersionCheck pluginVersionCheck, @Nullable Plugin plugin) {
        StringBuilder error = new StringBuilder();
        error.append("Atlassian Platform ").append((String)PLATFORM_VERSION_REF.get()).append(" must have ").append(pluginVersionCheck.getModuleName()).append("  version at least: ").append(pluginVersionCheck.getVersion());
        if (plugin == null) {
            error.append(" (no current version)");
        } else {
            error.append("  current version:").append(plugin.getPluginInformation().getVersion());
        }
        return error.toString();
    }
}

